<?php

// GET

if ( ! function_exists( 'wpj_get_ip' ) ) {
	function wpj_get_ip( $fields = '*', $where = '', $return = 'row' ) {
		$args = [
			'table'  => 'job_ipcache',
			'fields' => $fields,
			'where'  => $where,
			'return' => $return
		];

		return wpj_get_query_results( $args );
	}
}


// EXIST

if ( ! function_exists( 'wpj_ipcache_table_exist' ) ) {
	function wpj_ipcache_table_exist() {
		global $wpdb;

		if ( $wpdb->get_var( $wpdb->prepare( "SHOW TABLES LIKE %s", $wpdb->prefix . 'job_ipcache' ) ) === $wpdb->prefix . 'job_ipcache' )
			return true;

		return false;
	}
}


// INSERT

if ( ! function_exists( 'wpj_insert_ip' ) ) {
	function wpj_insert_ip( $data, $format ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $format ) === true ) return 0;

		$is_inserted = $wpdb->insert( $wpdb->prefix . 'job_ipcache', $data, $format );

		if ( $is_inserted === false ) return 0;

		return $wpdb->insert_id;
	}
}


// DELETE

if ( ! function_exists( 'wpj_delete_ip' ) ) {
	function wpj_delete_ip( $ip ) {
		global $wpdb;

		if ( empty( $ip ) === true ) return 0;

		$is_deleted = $wpdb->delete( $wpdb->prefix . 'job_ipcache', [ 'ipnr' => $ip ] );

		if ( $is_deleted === false ) return 0;

		return $is_deleted;
	}
}
