<?php

// GET

if ( ! function_exists( 'wpj_get_user_reviews' ) ) {
	function wpj_get_user_reviews( $uid = '' ) {
		$ratings_table = apply_filters( 'wpj_seller_reviews_database_table_filter', 'job_ratings', $uid );

		if ( $ratings_table == 'job_ratings' )
			$author_column = 'posts.post_author';

		else
			$author_column = 'ratings.uid';

		$reviews_number = wpj_get_option( 'wpjobster_job_author_reviews_number' );

		if ( ! is_numeric( $reviews_number ) || $reviews_number < 1 ) $reviews_number = 12;

		return wpj_get_order_rating(
			'orders.uid, ratings.grade, ratings.reason',
			[$ratings_table . ' ratings', 'job_orders orders', 'posts posts'],
			['ratings.awarded' => 1, $author_column => $uid],
			'results',
			$reviews_number,
			'ratings.datemade DESC'
		);
	}
}

if ( ! function_exists( 'wpj_get_user_review_response' ) ) {
	function wpj_get_user_review_response( $order_id, $pid, $post_author ) {
		$ratings_table = apply_filters( 'wpj_buyer_reviews_database_table_filter', 'job_ratings_by_seller', wpj_get_user_id() );

		return wpj_get_order_rating(
			'ratings.grade, ratings.reason, ratings.datemade',
			[$ratings_table . ' ratings', 'job_orders orders', 'posts posts'],
			['ratings.awarded' => 1, 'posts.post_author' => $post_author, 'posts.ID' => $pid, 'orders.id' => $order_id],
			'row',
			'',
			'ratings.datemade DESC'
		);
	}
}

if ( ! function_exists( 'wpj_get_buyer_awarded_job_rating_by_order_id' ) ) {
	function wpj_get_buyer_awarded_job_rating_by_order_id( $order_id ) {
		global $wpdb;

		return $wpdb->get_row( $wpdb->prepare(
			"
			SELECT
				id
			FROM
				{$wpdb->prefix}job_ratings
			WHERE
				awarded = 1
				AND orderid = %d
				AND orderid NOT IN (
					SELECT
						orderid
					FROM
						{$wpdb->prefix}job_ratings_by_seller
					WHERE
						orderid = %d
				)
			",
			$order_id,
			$order_id
		) );
	}
}


if ( ! function_exists( 'wpj_get_seller_rating_percent' ) ) {
	function wpj_get_seller_rating_percent( $uid = '' ) {
		$ratings_table = apply_filters( 'wpj_seller_reviews_database_table_filter', 'job_ratings', $uid );

		if ( $ratings_table == 'job_ratings' )
			$author_column = 'posts.post_author';

		else
			$author_column = 'ratings.uid';

		return ( int ) wpj_get_order_rating(
			'ROUND(((SUM(ratings.grade) * 100) / COUNT(*)) / 5)',
			[$ratings_table . ' ratings', 'job_orders orders', 'posts posts'],
			['ratings.awarded' => 1, $author_column => $uid],
			'var'
		);
	}
}

if ( ! function_exists( 'wpj_get_seller_rating_avg' ) ) {
	function wpj_get_seller_rating_avg( $uid ) {
		$ratings_table = apply_filters( 'wpj_seller_reviews_database_table_filter', 'job_ratings', $uid );

		if ( $ratings_table == 'job_ratings' )
			$author_column = 'posts.post_author';

		else
			$author_column = 'ratings.uid';

		return ( float ) wpj_get_order_rating(
			'DISTINCT AVG(ratings.grade)',
			[$ratings_table . ' ratings', 'job_orders orders', 'posts posts'],
			['ratings.awarded' => 1, $author_column => $uid],
			'var'
		);
	}
}

if ( ! function_exists( 'wpj_get_seller_reviews_number' ) ) {
	function wpj_get_seller_reviews_number( $uid ) {
		$ratings_table = apply_filters( 'wpj_seller_reviews_database_table_filter', 'job_ratings', $uid );

		if ( $ratings_table == 'job_ratings' )
			$author_column = 'posts.post_author';

		else
			$author_column = 'ratings.uid';

		return ( int ) wpj_get_order_rating(
			'COUNT( * )',
			[$ratings_table . ' ratings', 'job_orders orders', 'posts posts'],
			['ratings.awarded' => 1, $author_column => $uid],
			'var'
		);
	}
}