<?php

// GET

if ( ! function_exists( 'wpj_get_vacation' ) ) {
	function wpj_get_vacation( $fields = '*', $where = '', $return = 'row' ) {
		$args = [
			'table'  => 'job_uservacation',
			'fields' => $fields,
			'where'  => $where,
			'return' => $return
		];

		return wpj_get_query_results( $args );
	}
}


// INSERT

if ( ! function_exists( 'wpj_insert_vacation' ) ) {
	function wpj_insert_vacation( $data, $format ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $format ) === true ) return 0;

		$is_inserted = $wpdb->insert( $wpdb->prefix . 'job_uservacation', $data, $format );

		if ( $is_inserted === false ) return 0;

		return $wpdb->insert_id;
	}
}


// UPDATE

if ( ! function_exists( 'wpj_update_vacation' ) ) {
	function wpj_update_vacation( $data, $where ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $where ) === true ) return 0;

		$is_updated = $wpdb->update( $wpdb->prefix . 'job_uservacation', $data, $where );

		if ( $is_updated === false ) return 0;

		return $is_updated;
	}
}