<?php get_header();

$term = get_queried_object();

$posts = new WPJ_Load_More_Posts(
	[
		'function_name'   => 'wpj_display_blog_list_items',
		'posts_per_page'  => wpj_get_option( 'posts_per_page' ) ? wpj_get_option( 'posts_per_page' ) : 12,
		'post_status'     => 'publish',
		'container_class' => 'articles-grid ui three cards stackable',
		'post_type'       => ['news', 'post', 'job', 'request'],
		'tag'             => $term->slug
	]
);

wpj_get_template( 'tag-template.php', ['term' => $term, 'posts' => $posts] );

get_footer();