<?php
/**
 * @var $results
 * @var $width_value
 */
?>

<table align="center">

	<?php if ( $results ) { $i = 0;

		foreach ( $results as $key => $result ) {

			$package_price = get_post_meta( $result->ID, 'package_price', true );

			if ( $i == 0 ) { ?>

				<tr style="display: flex;">

			<?php } ?>

					<td width="<?php echo $width_value; ?>" style="margin: .5em; max-width: 100%; min-height: 0; background: #fdfdfd; padding-bottom: 5px; border: 1px solid #e7e8e9;">

						<!-- Image -->
						<a href="<?php echo get_permalink( $result->ID ); ?>" style="display: block; width: 100%; background: #000; padding: 0; cursor: pointer;">

							<div style="width:100%; height: 100px; display: flex;">

								<img alt="" style="display: block; height: auto; max-width: 100%; max-height: 100%; margin: 0 auto;" src="<?php echo wpj_get_job_image( $result->ID ); ?>" />

							</div>

						</a>

						<!-- Title -->
						<div style="padding: .75em 1em; border: none; border-top: 1px solid rgba(34, 36, 38, 0.1); background: none; margin: 0; font-size: 1em; text-overflow: ellipsis; overflow: hidden; width: 160px; white-space: nowrap;">

							<a href="<?php echo get_permalink( $result->ID ); ?>" title=""><?php echo $result->post_title; ?></a>

						</div>

						<!-- User & Price -->
						<div style="padding: .6em .5em .75em .1em; border: none; border-top: 1px solid rgba(34, 36, 38, 0.1); background: none; margin: 0; font-size: 1em;">

							<!-- Avatar -->
							<div style="float: left;">

								<a style="width: 2.5em; height: 2.5em; margin-top: -2px; margin-left: 0; margin-right: .5em; cursor: pointer; position: relative; display: inline-block; vertical-align: middle; max-width: 100%; background-color: transparent;" href="<?php echo wpj_get_user_profile_link( $result->post_author ); ?>">

									<img alt="" style="width: 2.5em; height: 2.5em; margin-left: 0; margin-right: .5em; display: inline-block; vertical-align: middle;max-width: 100%;" src="<?php echo wpj_get_avatar( $result->post_author, 28, 28 ); ?>">

								</a>

							</div>

							<!-- Price -->
							<div style="font-size: 1.2em; font-weight: 700; line-height: 15px; float: right; text-align: right;">

								<?php if ( get_post_meta( $result->ID, 'job_packages', true ) == 'yes' && $package_price ) {

									$package_price = array_diff( $package_price, array( null ) ); ?>

									<span style="text-transform: uppercase; font-size: .714rem; vertical-align: middle; font-weight: 700; display: block;">

										<?php _e( 'Starting at', 'wpjobster' ); ?>

									</span>

									<?php echo wpj_show_price( min( $package_price ) );

								} elseif ( get_post_meta( $result->ID, 'price_type', true ) ) { ?>

									<span style="text-transform: uppercase; font-size: .714rem; vertical-align: middle; font-weight: 700; display: block;">

										<?php echo apply_filters( 'wpj_price_type_filter', sprintf( __( '%s Rate', 'wpjobster' ), wpj_translate_string( get_post_meta( $result->ID, 'price_type', true ) ) ), $result->ID ); ?>

									</span>

									<?php echo wpj_show_price( get_post_meta( $result->ID, 'price', true ), 2, true );

								} else {

									echo wpj_show_price( get_post_meta( $result->ID, 'price', true ), 2, true );

								} ?>

							</div>

						</div>

					</td>

			<?php $i++; if ( $i == 3 ) { ?>

				</tr>

			<?php $i = 0; }
		}

	} else {

		_e( 'No active jobs', 'wpjobster' );

	} ?>

</table>