<?php
/**
 * @var $postthumb_cnt_classes
 * @var $job_is_featured
 * @var $jobster_design
 * @var $pid
 * @var $location_display
 * @var $userdata
 * @var $ratinggrade
 * @var $rating_count
 */
?>

<!-- Job Card -->
<div class="job-card ui card wpj-card-style-2 <?php echo $postthumb_cnt_classes; ?>">

	<!-- Job Image -->
	<a class="image" href="<?php the_permalink( $pid ); ?>">
		<div class="card-image-clipper">
			<div class="card-image-helper">
				<img class="card-blurry-bg" src="<?php echo wpj_get_job_image( $pid ); ?>" alt="<?php the_title( $pid ); ?>" />
				<img class="my_image" src="<?php echo wpj_get_job_image( $pid ); ?>" alt="<?php the_title( $pid ); ?>" />
			</div>
		</div>

		<!-- Top Icons -->
		<div class="card-image-icons top">

			<!-- Featured -->
			<?php if ( $job_is_featured ) { ?>

				<span class="ui mini pink label uppercase"><?php _e( 'Featured', 'wpjobster' ); ?></span>

			<?php } ?>

		</div>

		<!-- Bottom Icons -->
		<div class="card-image-icons bottom text-right">

			<?php do_action( 'wpj_before_card_rich_icons', $pid ); ?>

			<!-- Distance -->
			<?php if ( wpj_bool_option( 'wpjobster_html5_geolocation_enable' ) && ( $distance = wpj_get_distance_to_job_location( 'post', $pid ) ) ) { ?>

				<div class="ui small horizontal label di z-index-bigger distance-label"><?php echo $distance; ?></div>

			<?php } ?>

			<!-- Let's Meet -->
			<?php if ( wpj_bool_option( 'wpjobster_lets_meet' ) && get_post_meta( $pid, 'lets_meet', true ) ) { ?>

				<div class="di z-index-bigger" data-inverted="" data-tooltip="<?php echo _x( 'Let\'s meet', 'Job Section', 'wpjobster' ) . $location_display; ?>" data-position="top right">

					<?php if ( $jobster_design['lets_meet_rich_icon_options_job'] ) { ?>

						<i class="small circular inverted bordered <?php echo $jobster_design['lets_meet_rich_icon_options_job']; ?> icon"></i>

					<?php } else { ?>

						<i class="small circular inverted bordered blue map marker icon"></i>

					<?php } ?>

				</div>

			<?php } ?>

			<!-- Instant Delivery -->
			<?php if ( wpj_bool_option( 'wpjobster_enable_instant_delivery' ) && get_post_meta( $pid, "instant", true ) ) { ?>

				<div class="di z-index-bigger" data-inverted="" data-tooltip="<?php _e( 'Instant Delivery', 'wpjobster' ); ?>" data-position="top right">

					<?php if ( $jobster_design['instant_delivery_rich_icon_options_job'] ) { ?>

						<i class="small circular inverted bordered <?php echo $jobster_design['instant_delivery_rich_icon_options_job']; ?> icon"></i>

					<?php } else { ?>

						<i class="small circular inverted bordered green arrow circle down icon"></i>

					<?php } ?>

				</div>

			<?php } ?>

			<!-- Free Shipping -->
			<?php if ( $shipping <= 0 ) { ?>

				<div class="di z-index-big" data-inverted="" data-tooltip="<?php _e( 'Free Shipping', 'wpjobster' ); ?>" data-position="bottom left">

					<?php if ( $jobster_design['free_shipping_slider_icon_options_job'] ) { ?>

						<i class="small circular inverted bordered <?php echo $jobster_design['free_shipping_slider_icon_options_job']; ?> icon"></i>

					<?php } else { ?>

						<i class="small circular inverted bordered truck icon"></i>

					<?php } ?>

				</div>

			<?php }

			do_action( 'wpj_after_card_rich_icons', $pid ); ?>

		</div>
	</a>

	<!-- Title -->
	<div class="content wpj-small list-70-right">
		<a class="list-header" href="<?php the_permalink( $pid ); ?>" title=""><?php echo wpj_trim( $post->post_title, 65 ); ?></a>

		<div class="description visible-on-list" style="display: none;">

			<?php echo wpj_trim( wpj_apply_filter_to_string( wp_strip_all_tags( $post->post_content, true ), false, 'joblistings' ), 200 ); ?>

		</div>
	</div>

	<!-- User, Rating, Price -->
	<div class="content wpj-small df list-70-right">

		<!-- Avatar -->
		<div class="flex-slave text-vertical-center">
			<a class="ui avatar image" href="<?php echo wpj_get_user_profile_link( $userdata->user_login ); ?>">

				<?php wpj_display_user_photo( array( 'uid' => $userdata->ID, 'width' => 28, 'height' => 28, 'with_level_image' => false, 'with_link' => false ) );

				if ( ! empty( $jobster_design['wpjobster_user_level_for_thumbnails'] ) ) {

					if ( wpj_get_user_level( $post->post_author ) == 1 ) { ?>

						<span class="avatar-badge" data-tooltip="<?php _e( 'Rookie Seller', 'wpjobster' ); ?>" data-position="top left" data-inverted="">

							<?php if ( ! empty( $jobster_design['level1_card_icon_options_user']['url'] ) ) { ?>

								<img src="<?php echo $jobster_design['level1_card_icon_options_user']['url']; ?>" alt="user-badge">

							<?php } else { ?>

								<img src="<?php echo get_template_directory_uri() . '/assets/images/card/top-user-badge-icon-lvl1.png'; ?>" alt="user-badge-server">

							<?php } ?>

						</span>

					<?php } elseif ( wpj_get_user_level( $post->post_author ) == 2 ) { ?>

						<span class="avatar-badge" data-tooltip="<?php _e( 'Master Seller', 'wpjobster' ); ?>" data-position="top left" data-inverted="">

							<?php if ( ! empty( $jobster_design['level2_card_icon_options_user']['url'] ) ) { ?>

								<img src="<?php echo $jobster_design['level2_card_icon_options_user']['url']; ?>" alt="user-badge">

							<?php } else { ?>

								<img src="<?php echo get_template_directory_uri() . '/assets/images/card/top-user-badge-icon-lvl2.png'; ?>" alt="user-badge-server">

							<?php } ?>

						</span>

					<?php }

				}

				if ( wpj_get_user_level( $post->post_author ) == 3 ) { ?>

					<span class="avatar-badge" data-tooltip="<?php _e( 'Top Rated Seller', 'wpjobster' ); ?>" data-position="top left" data-inverted="">

						<?php if ( ! empty( $jobster_design['level3_card_icon_options_user']['url'] ) ) { ?>

							<img src="<?php echo $jobster_design['level3_card_icon_options_user']['url']; ?>" alt="user-badge">

						<?php } else { ?>

							<img src="<?php echo get_template_directory_uri() . '/assets/images/card/top-user-badge-icon-lvl3.png'; ?>" alt="user-badge-server">

						<?php } ?>

					</span>

				<?php } ?>

			</a>

		</div>

		<!-- Name, Rating -->
		<div class="flex-slave ellipsis text-vertical-center">
			<div class="name ellipsis">
				<a href="<?php echo wpj_get_user_profile_link( $userdata->user_login ); ?>">
					<strong><?php echo wpj_trim( wpj_get_user_display_type( $userdata->ID ), 22 ); ?></strong>
				</a>
			</div>

			<?php if ( $jobster_design['enable_rating_count_cards'] == true ) { ?>

				<div class="wpj-star-rating-static-single">

					<i class="star icon static"></i>

					<?php if ( $ratinggrade != 0 && wpj_get_job_reviews_number( $pid ) >= $rating_count ) { ?>

						<span class="wpj-star-text-style"><strong><?php echo number_format( wpj_get_job_rating_avg( $pid ), 1 ); ?></strong></span>
						<span class="meta">(<?php echo wpj_get_job_reviews_number( $pid ); ?>)</span>

					<?php } else { ?>

						<span class="wpj-star-text-style"><strong>0</strong></span>
						<span class="meta">(<?php echo wpj_get_job_reviews_number( $pid ); ?>)</span>

					<?php } ?>

				</div>

			<?php } ?>

		</div>

		<!-- Price -->
		<div class="flex-master card-job-price text-right text-vertical-center">

			<?php if ( wpj_get_option( 'wpjobster_packages_enabled' ) == 'yes' && get_post_meta( $pid, 'job_packages', true ) == 'yes' && get_post_meta( $pid, 'package_price', true ) ) { ?>

				<span class="small-job"><?php _e( 'Starting at', 'wpjobster' ); ?></span>

				<?php echo wpj_show_price( min( array_diff( get_post_meta( $pid, 'package_price', true ), array( null ) ) ) );

			} elseif ( get_post_meta( $pid, 'price_type', true ) ) { ?>

				<span class="small-job"><?php echo apply_filters( 'wpj_price_type_filter', sprintf( __( '%s Rate', 'wpjobster' ), wpj_translate_string( get_post_meta( $pid, 'price_type', true ) ) ), $pid ); ?></span>

				<?php echo wpj_show_price( get_post_meta( $pid, 'price', true ), 2, true );

			} else {

				echo wpj_show_price( get_post_meta( $pid, 'price', true ), 2, true );

			} ?>

		</div>
	</div>
</div>