<?php
/**
 * @var $postthumb_cnt_classes
 * @var $job_is_featured
 * @var $pid
 * @var $userdata
 * @var $ratinggrade
 * @var $rating_count
 */
?>

<div class="job-card ui card wpj-card-style-1 overflow-hidden <?php echo $postthumb_cnt_classes; ?>">

	<div class="content card-pusher-master list-70-right">

		<a class="card-username" href="<?php echo wpj_get_user_profile_link( $userdata->user_login ); ?>">

			<?php wpj_display_user_photo( array( 'uid' => $userdata->ID, 'width' => 28, 'height' => 28, 'with_level_image' => false, 'with_link' => false, 'img_class' => 'ui wpj-small avatar image' ) );

			echo wpj_trim( wpj_get_user_display_type( $userdata->ID ), 22 ); ?>

		</a>

		<div class="card-rating meta">

			<?php if ( ! empty( $jobster_design['enable_rating_count_cards'] ) && $jobster_design['enable_rating_count_cards'] == true ) { ?>

				<div class="wpj-star-rating-static-single">

					<i class="star icon static"></i>

					<?php if ( $ratinggrade != 0 && wpj_get_job_reviews_number( $pid ) >= $rating_count ) { ?>

						<span class="wpj-star-text-style"><strong><?php echo number_format( wpj_get_job_rating_avg( $pid ), 1 ); ?></strong></span>
						<span class="meta">(<?php echo wpj_get_job_reviews_number( $pid ); ?>)</span>

					<?php } else { ?>

						<span class="wpj-star-text-style"><strong>0</strong></span>
						<span class="meta">(<?php echo wpj_get_job_reviews_number( $pid ); ?>)</span>

					<?php } ?>

				</div>

			<?php } ?>

		</div>
	</div>

	<a class="image card-pusher-slave" href="<?php the_permalink( $pid ); ?>">
		<div class="card-image-clipper">
			<div class="card-image-helper">
				<img class="card-blurry-bg" src="<?php echo wpj_get_job_image( $pid ); ?>" alt="<?php the_title( $pid ); ?>" />
				<img class="my_image" src="<?php echo wpj_get_job_image( $pid ); ?>" alt="<?php the_title( $pid ); ?>" />
			</div>
		</div>
	</a>

	<div class="content card-pusher-cover list-70-right pr">

		<?php if ( wpj_bool_option( 'wpjobster_html5_geolocation_enable' ) && ( $distance = wpj_get_distance_to_job_location( 'post', $pid ) ) ) { ?>

			<div class="ui small horizontal label right z-index-bigger wpj-distance-label"><?php echo $distance; ?></div>

		<?php } ?>

		<a class="header" href="<?php the_permalink( $pid ); ?>"><?php echo wpj_trim( $post->post_title, 65 ); ?></a>

		<div class="description visible-on-list" style="display: none;">

			<?php echo wpj_trim( wpj_apply_filter_to_string( wp_strip_all_tags( $post->post_content, true ), false, 'joblistings' ), 200 ); ?>

		</div>

	</div>

	<div class="extra content list-70-right">

		<?php do_action( 'wpj_before_card_simple_icons', $pid );

		if ( $job_is_featured ) { ?>

			<div class="featured-job card-old-icon">
				<div class="featured-icon" data-tooltip="<?php _e( "Featured", "wpjobster" ); ?>" data-position="top left" data-inverted="">

					<?php if ( ! empty( $jobster_design['featured_simple_icon_options_job']['url'] ) ) { ?>

						<img src="<?php echo $jobster_design['featured_simple_icon_options_job']['url']; ?>" alt="featured">

					<?php } else { ?>

						<img src="<?php echo get_template_directory_uri() . '/assets/images/card/circle-featured.png'; ?>" alt="featured">

					<?php } ?>

				</div>
			</div>

		<?php } ?>

		<?php if ( wpj_bool_option( 'wpjobster_lets_meet' ) && get_post_meta( $pid, 'lets_meet', true ) ) { ?>

			<div class="lets-meet card-old-icon">
				<div class="lets-meet-icon" data-tooltip="<?php _ex( "Let's meet", "Job Section", "wpjobster" ); ?>" data-position="top left" data-inverted="">

					<?php if ( ! empty( $jobster_design['lets_meet_simple_icon_options_job']['url'] ) ) { ?>

						<img src="<?php echo $jobster_design['lets_meet_simple_icon_options_job']['url']; ?>" alt="lets-meet">

					<?php } else { ?>

						<img src="<?php echo get_template_directory_uri() . '/assets/images/card/shake-icon.png'; ?>" alt="lets-meet">
					<?php } ?>

				</div>
			</div>

		<?php }

		if ( wpj_bool_option( 'wpjobster_enable_instant_delivery' ) && get_post_meta( $pid, "instant", true ) ) { ?>

			<div class="instant-job card-old-icon">
				<div class="instant-icon" data-tooltip="<?php _e( "Instant", "wpjobster" ); ?>" data-position="top left" data-inverted="">

					<?php if ( ! empty( $jobster_design['instant_delivery_simple_icon_options_job']['url'] ) ) { ?>

						<img src="<?php echo $jobster_design['instant_delivery_simple_icon_options_job']['url']; ?>" alt="instant">

					<?php } else { ?>

						<img src="<?php echo get_template_directory_uri() . '/assets/images/card/circle-instant.png'; ?>" alt="instant">

					<?php } ?>
				</div>
			</div>

		<?php }

		if ( $shipping <= 0 ) { ?>

			<div class="free-shipping-job card-old-icon">
				<div class="free-shipping-icon" data-tooltip="<?php _e( "Free shipping", "wpjobster" ); ?>" data-position="top left" data-inverted="">

					<?php if ( ! empty( $jobster_design['free_shipping_simple_icon_options_job']['url'] ) ) { ?>

						<img src="<?php echo $jobster_design['free_shipping_simple_icon_options_job']['url']; ?>" alt="free-shipping">

					<?php } else { ?>

						<img src="<?php echo get_template_directory_uri() . '/assets/images/card/free-icon.svg'; ?>" alt="free-shipping">

					<?php } ?>
				</div>
			</div>

		<?php }

		do_action( 'wpj_after_card_simple_icons', $pid );

		if ( ! empty( $jobster_design['wpjobster_user_level_for_thumbnails'] ) ) {

			if ( wpj_get_user_level( $post->post_author ) == 1 ) { ?>

				<div class="top-user-badge card-old-icon">
					<div class="top-user-badge-icon" data-tooltip="<?php _e( "Rookie Seller", "wpjobster" ); ?>" data-position="top left" data-inverted="">

						<?php if ( ! empty( $jobster_design['level1_card_icon_options_user']['url'] ) ) { ?>

							<img src="<?php echo $jobster_design['level1_card_icon_options_user']['url']; ?>" alt="user-badge">

						<?php } else { ?>

							<img src="<?php echo get_template_directory_uri() . '/assets/images/card/top-user-badge-icon-lvl1.png'; ?>" alt="user-badge-server">

						<?php } ?>

					</div>
				</div>

			<?php }

			if ( wpj_get_user_level( $post->post_author ) == 2 ) { ?>

				<div class="top-user-badge card-old-icon">
					<div class="top-user-badge-icon" data-tooltip="<?php _e( "Master Seller", "wpjobster" ); ?>" data-position="top left" data-inverted="">

						<?php if ( ! empty( $jobster_design['level2_card_icon_options_user']['url'] ) ) { ?>

							<img src="<?php echo $jobster_design['level2_card_icon_options_user']['url']; ?>" alt="user-badge">

						<?php } else { ?>

							<img src="<?php echo get_template_directory_uri() . '/assets/images/card/top-user-badge-icon-lvl2.png'; ?>" alt="user-badge-server">

						<?php } ?>

					</div>
				</div>

			<?php }
		}

		if ( wpj_get_user_level( $post->post_author ) == 3 ) { ?>

			<div class="top-user-badge card-old-icon">
				<div class="top-user-badge-icon" data-tooltip="<?php _e( "Top Rated Seller", "wpjobster" ); ?>" data-position="top left" data-inverted="">

					<?php if ( ! empty( $jobster_design['level3_card_icon_options_user']['url'] ) ) { ?>

						<img src="<?php echo $jobster_design['level3_card_icon_options_user']['url']; ?>" alt="user-badge">

					<?php } else { ?>

						<img src="<?php echo get_template_directory_uri() . '/assets/images/card/top-user-badge-icon-lvl3.png'; ?>" alt="user-badge-server">

					<?php } ?>

				</div>
			</div>

		<?php } ?>

		<div class="right floated meta">

			<span class="card-job-price">

				<?php if ( wpj_get_option( 'wpjobster_packages_enabled' ) == 'yes' && get_post_meta( $pid, 'job_packages', true ) == 'yes' && get_post_meta( $pid, 'package_price', true ) ) { ?>

					<span class="small-job"><?php _e( 'Starting at', 'wpjobster' ); ?></span>

					<?php echo wpj_show_price( min( array_diff( get_post_meta( $pid, 'package_price', true ), array( null ) ) ) );

				} elseif ( get_post_meta( $pid, 'price_type', true ) ) { ?>

					<span class="small-job"><?php echo apply_filters( 'wpj_price_type_filter', sprintf( __( '%s Rate', 'wpjobster' ), wpj_translate_string( get_post_meta( $pid, 'price_type', true ) ) ), $pid ); ?></span>

					<?php echo wpj_show_price( get_post_meta( $pid, 'price', true ), 2, true );

				} else {

					echo wpj_show_price( get_post_meta( $pid, 'price', true ), 2, true );

				} ?>

			</span>

		</div>
	</div>
</div>