<?php
/**
 * @var $job_is_featured
 * @var $jobster_design
 * @var $pid
 * @var $display_slider
 * @var $slider_elements
 * @var $video_arr
 * @var $images_arr
 * @var $review_samples
 * @var $location_display
 * @var $userdata
 * @var $ratinggrade
 * @var $rating_count
 * @var $package_price_vals
 * @var $icons_cnt
 */
?>

<!-- Job Card -->
<div class="job-card ui card wpj-card-style-3<?php if ( $job_is_featured || $jobster_design['enable_rating_count_cards'] == true ) { echo " extra-slider-height"; } if ( $jobster_design['border_over_box_shadow'] == true ) { echo " job-card-with-border"; } ?>">

	<!-- Job Image -->
	<div class="image">

		<!-- Featured -->
		<?php if ( $job_is_featured ) { ?>

			<div class="job-featured">

				<?php if ( $jobster_design['featured_slider_icon_options_job'] ) { ?>

					<i class="<?php echo $jobster_design['featured_slider_icon_options_job']; ?> icon"></i>

				<?php } else { ?>

					<span class="ui mini pink label uppercase"><?php _e( 'Featured', 'wpjobster' ); ?></span>

				<?php } ?>

			</div>

		<?php } ?>

		<!-- Show until slider, load then remove -->
		<div class="card-image-clipper">
			<div class="card-image-helper">
				<img class="card-blurry-bg" src="<?php echo wpj_get_job_image( $pid ); ?>" alt="<?php the_title( $pid ); ?>" />
				<img class="my_image" src="<?php echo wpj_get_job_image( $pid ); ?>" alt="<?php the_title( $pid ); ?>" />
			</div>
		</div>

		<!-- Show slider -->
		<?php if ( $display_slider ) { ?>

			<div class="wpj-carousel owl-carousel owl-theme">

				<?php if ( $slider_elements > 0 ) {

					// Video before images
					if ( get_post_meta( $pid, 'video_as_job_thumbnail', true ) != 'no' ) {
						if ( $video_arr ) {
							foreach ( $video_arr as $key => $value ) {
								if ( $value && wpj_get_video_url_type( $value ) ) { ?>

									<a class="owl-video" href="<?php echo $value; ?>"></a>

								<?php }
							}
						}
					}

					// Images
					$counter = 0;
					foreach ( $images_arr as $image ) {
						$image_src = wpj_get_attachment_image_url( $image->ID, 'job_slider_image' );

						if ( $counter > 0 ) {
							$lazy_class = 'bx-lazy owl-lazy';
							$lazy_src   = get_template_directory_uri() . '/assets/images/media/blank.gif';

						} else {
							$lazy_class = '';
							$lazy_src   = $image_src;

						} ?>

						<a href="<?php the_permalink( $pid ); ?>" class="slide-img">
							<img src="<?php echo $lazy_src; ?>" class="job-blurry-bg <?php echo $lazy_class; ?>" data-src="<?php echo $image_src; ?>" alt="" />
							<img src="<?php echo $lazy_src; ?>" class="<?php echo $lazy_class; ?>" data-src="<?php echo $image_src; ?>" alt="" />
						</a>

						<?php $counter++;
					}

					// Video after images
					if ( get_post_meta( $pid, 'video_as_job_thumbnail', true ) == 'no' ) {
						if ( $video_arr ) {
							foreach ( $video_arr as $key => $value ) {
								if ( $value && wpj_get_video_url_type( $value ) ) { ?>

									<a class="owl-video" href="<?php echo $value; ?>"></a>

								<?php }
							}
						}
					}

					// Review work samples
					if ( wpj_get_option( 'wpjobster_enable_review_work_samples' ) == 'yes' ) {
						foreach ( $review_samples as $sample ) {
							$image_src  = wpj_get_attachment_image_url( $sample->sample_id, 'job_slider_image' );
							$lazy_class = 'bx-lazy owl-lazy';
							$lazy_src   = get_template_directory_uri() . '/assets/images/media/blank.gif'; ?>

							<a href="<?php the_permalink( $pid ); ?>" class="slide-img">
								<img src="<?php echo $lazy_src; ?>" class="job-blurry-bg <?php echo $lazy_class; ?>" data-src="<?php echo $image_src; ?>"  alt="" />
								<img src="<?php echo $lazy_src; ?>" class="<?php echo $lazy_class; ?>" data-src="<?php echo $image_src; ?>"  alt="" />
								<div class="work-sample-caption">
									<small>
										<blockquote><b><?php echo $sample->reason; ?></b></blockquote>
										<?php echo sprintf( __( 'Reviewed by %1$s', "wpjobster" ), wpj_get_user_display_type( $sample->uid ) ); ?>
									</small>
								</div>
							</a>

							<?php $counter++;
						}
					}

				} else {

					$lazy_class = 'bx-lazy owl-lazy';
					$image_src  = ! empty( $jobster_design['no_image_icon_options_job']['url'] ) ? $jobster_design['no_image_icon_options_job']['url'] : get_template_directory_uri() . '/assets/images/dummy/placeholder.webp';
					$lazy_src   = $image_src; ?>

					<a href="<?php the_permalink( $pid ); ?>" class="slide-img">
						<img src="<?php echo $lazy_src; ?>" class="job-blurry-bg <?php echo $lazy_class; ?>" data-src="<?php echo $image_src; ?>" alt="" />
						<img src="<?php echo $lazy_src; ?>" class="<?php echo $lazy_class; ?>" data-src="<?php echo $image_src; ?>" alt="" />
					</a>

				<?php } ?>

			</div>

		<?php } ?>

	</div>

	<!-- User -->
	<div class="user-area">

		<!-- User Avatar -->
		<div class="user-avatar">

			<?php wpj_display_user_photo( array( 'uid' => $userdata->ID, 'width' => 55, 'height' => 55, 'with_level_image' => false, 'link_class' => 'user-avatar-image' ) ); ?>

		</div>

		<!-- Username & Level -->
		<div class="user-content<?php if ( ! empty( $jobster_design['rating_slider_after_title'] ) ) echo ' mr0'; ?>">
			<a href="<?php echo wpj_get_user_profile_link( $userdata->user_login ); ?>" class="cards-user-link">

				<!-- Name -->
				<div class="user-name"><?php echo apply_filters( 'wpj_card_slider_layout_username_filter', wpj_trim( wpj_get_user_display_type( $userdata->ID ), 22 ), wpj_get_user_display_type( $userdata->ID ), $userdata->ID ); ?></div>

				<!-- Level -->
				<?php if ( ! empty( $jobster_design['wpjobster_user_level_for_thumbnails'] ) )
					wpj_display_user_level_label( $post->post_author ); ?>

			</a>
		</div>

		<!-- Rating after user details -->
		<?php if ( empty( $jobster_design['rating_slider_after_title'] ) ) {

			if ( $jobster_design['enable_rating_count_cards'] == true ) { ?>

				<div class="user-rating">

					<div class="wpj-rating-single">

						<i class="star icon static"></i>

						<?php if ( $ratinggrade != 0 && wpj_get_job_reviews_number( $pid ) >= $rating_count ) { ?>

							<span class="rating-score"><strong><?php echo number_format( wpj_get_job_rating_avg( $pid ), 1 ); ?></strong></span>
							<span class="rating-reviews-number">(<?php echo wpj_get_job_reviews_number( $pid ); ?>)</span>

						<?php } else { ?>

							<span class="rating-score"><strong>0</strong></span>
							<span class="rating-reviews-number">(<?php echo wpj_get_job_reviews_number( $pid ); ?>)</span>

						<?php } ?>

					</div>

				</div>

			<?php }

		} ?>

	</div>

	<!-- Title -->
	<div class="job-area">
		<a class="title list-header" href="<?php the_permalink( $pid ); ?>" title=""><?php echo wpj_trim( $post->post_title, 65 ); ?></a>

		<div class="description visible-on-list">

			<?php echo wpj_trim( wpj_apply_filter_to_string( wp_strip_all_tags( $post->post_content, true ), false, 'joblistings' ), 200 ); ?>

		</div>

		<!-- Rating after title -->
		<?php if ( ! empty( $jobster_design['rating_slider_after_title'] ) ) {

			if ( $jobster_design['enable_rating_count_cards'] == true ) { ?>

				<div class="user-rating mt10">

					<div class="wpj-rating-single">

						<i class="star icon static"></i>

						<?php if ( $ratinggrade != 0 && wpj_get_job_reviews_number( $pid ) >= $rating_count ) { ?>

							<span class="rating-score"><strong><?php echo number_format( wpj_get_job_rating_avg( $pid ), 1 ); ?></strong></span>
							<span class="rating-reviews-number">(<?php echo wpj_get_job_reviews_number( $pid ); ?>)</span>

						<?php } else { ?>

							<span class="rating-score"><strong>0</strong></span>
							<span class="rating-reviews-number">(<?php echo wpj_get_job_reviews_number( $pid ); ?>)</span>

						<?php } ?>

					</div>

				</div>

			<?php }

		} ?>

	</div>

	<!-- Price & Let's Meet & Favorites -->
	<div class="job-bottom-info">
		<div class="job-price-area">

			<!-- Price -->
			<div class="job-price">

				<?php if ( get_post_meta( $pid, 'job_packages', true ) == 'yes' && $package_price_vals ) { ?>
					<div class="price-type"><?php _e( 'Starting at', 'wpjobster' ); ?></div>
					<div class="price"><?php echo wpj_show_price( min( $package_price_vals ) ); ?></div>

				<?php } elseif ( get_post_meta( $pid, 'price_type', true ) ) { ?>

					<div class="price-type"><?php echo apply_filters( 'wpj_price_type_filter', sprintf( __( '%s Rate', 'wpjobster' ), wpj_translate_string( get_post_meta( $pid, 'price_type', true ) ) ), $pid ); ?></div>
					
					<?php if ( get_post_meta( $pid, 'price_type', true ) !== 'custom' ) { ?>

						<div class="price"><?php echo wpj_show_price( get_post_meta( $pid, 'price', true ), 2, true ); ?></div>

					<?php } ?>

				<?php } else { ?>

					<div class="price"><?php echo wpj_show_price( get_post_meta( $pid, 'price', true ), 2, true ); ?></div>

				<?php } ?>

			</div>

			<div class="card-icons <?php if ( $icons_cnt < 2 ) echo 'one-item'; ?>">

				<?php do_action( 'wpj_before_card_slider_icons', $pid ); ?>
		
				<!-- Instant Delivery -->
				<?php if ( wpj_bool_option( 'wpjobster_enable_instant_delivery' ) && get_post_meta( $pid, "instant", true ) ) { ?>

					<div class="job-instant-delivery" data-inverted="" data-tooltip="<?php _e( 'Instant Delivery', 'wpjobster' ); ?>" data-position="top center">

						<?php if ( $jobster_design['instant_delivery_slider_icon_options_job'] ) { ?>

							<i class="<?php echo $jobster_design['instant_delivery_slider_icon_options_job']; ?> icon"></i>

						<?php } else { ?>

							<i class="icon icon-img"><img src="<?php echo get_template_directory_uri() . '/assets/images/card/instant-delivery-icon.svg'; ?>" alt=""></i>

						<?php } ?>

					</div>

				<?php } ?>

				<!-- Let's Meet -->
				<?php if ( wpj_bool_option( 'wpjobster_lets_meet' ) && get_post_meta( $pid, 'lets_meet', true ) ) { ?>

					<div class="job-lets-meet" data-inverted="" data-tooltip="<?php echo _x( 'Let\'s meet', 'Job Section', 'wpjobster' ) . $location_display; ?>" data-position="top center">

						<?php if ( isset( $jobster_design['lets_meet_slider_icon_options_job'] ) && $jobster_design['lets_meet_slider_icon_options_job'] ) { ?>

							<i class="<?php echo $jobster_design['lets_meet_slider_icon_options_job']; ?> icon"></i>

						<?php } else { ?>

							<i class="icon icon-img"><img src="<?php echo get_template_directory_uri() . '/assets/images/card/location-icon.svg'; ?>" alt=""></i>

						<?php } ?>

					</div>

				<?php } ?>

				<!-- Distance -->
				<?php if ( wpj_bool_option( 'wpjobster_html5_geolocation_enable' ) && ( $distance = wpj_get_distance_to_job_location( 'post', $pid ) ) ) { ?>

					<div class="job-distance" data-inverted="" data-tooltip="<?php echo $distance; ?>" data-position="top center">

						<?php if ( isset( $jobster_design['distance_slider_icon_options_job'] ) && $jobster_design['distance_slider_icon_options_job'] ) { ?>

							<i class="<?php echo $jobster_design['distance_slider_icon_options_job']; ?> icon"></i>

						<?php } else { ?>

							<i class="icon icon-img"><img src="<?php echo get_template_directory_uri() . '/assets/images/card/distance-icon.svg'; ?>" alt=""></i>

						<?php } ?>

					</div>

				<?php } ?>

				<!-- Free Shipping -->
				<?php if ( $shipping <= 0 ) { ?>

					<div class="job-free-shipping" data-inverted="" data-tooltip="<?php _e( 'Free Shipping', 'wpjobster' ); ?>" data-position="top center">

						<?php if ( $jobster_design['free_shipping_slider_icon_options_job'] ) { ?>

							<i class="<?php echo $jobster_design['free_shipping_slider_icon_options_job']; ?> icon"></i>

						<?php } else { ?>

							<i class="icon icon-img"><img src="<?php echo get_template_directory_uri() . '/assets/images/card/free-icon.svg'; ?>" alt=""></i>

						<?php } ?>

					</div>

				<?php }

				do_action( 'wpj_after_card_slider_icons', $pid ); ?>

			</div>

		</div>

		<!-- Favorites -->
		<div class="job-favorites">

			<div data-inverted="" data-tooltip="<?php _e( 'Favorites', 'wpjobster' ); ?>" data-position="top center">

				<?php if ( $jobster_design['favorites_slider_icon_options_job'] ) {

					wpj_display_job_favorite_icon( $pid, '<i class="' . $jobster_design['favorites_slider_icon_options_job'] . ' red icon"></i>', '<i class="' . $jobster_design['favorites_slider_icon_options_job'] . ' outline grey icon"></i>' );

				} else {

					wpj_display_job_favorite_icon( $pid, '<i class="heart red icon"></i>', '<i class="heart outline grey icon"></i>' );

				} ?>

			</div>

		</div>

	</div>

</div>