<?php
/**
 * @var $sliders_info
 * @var $categories
 * @var $levels_arr
 * @var $price_type_arr
 */
?>

<div class="home-hero-slider-wrapper">

	<div class="home-hero-slider owl-carousel js-wpj-home-hero-slider">

		<?php if ( $sliders_info ) {
			foreach ( $sliders_info as $slider_info ) { ?>

				<div class="home-hero-slide" style="background-image: url(<?php echo $slider_info['image']; ?>);">
					<div class="main-content">
						<div class="slide-content">
							<div class="slide-title"><?php echo $slider_info['title']; ?></div>

							<div class="slide-description"><?php echo $slider_info['content']; ?></div>

							<div class="categories-wrapper">

								<?php if ( $categories ) { $i = 0;
									foreach ( $categories as $category ) {
										if ( $i < 3 ) { ?>

											<a href="<?php echo get_category_link( $category->term_id ); ?>" class="category" title=""><?php echo $category->name; ?></a>

										<?php }
									$i++; }
								} ?>

								<span class="category-extender"><?php _e( '... and many more!', 'wpjobster' ); ?></span>
							</div>

							<div class="slide-review">
								<div class="review-rating">
									<?php for ( $i = 0; $i < $slider_info['reviewer_stars']; $i++ ) { ?>

										<img src="<?php echo get_template_directory_uri() . '/assets/images/star/star-full.svg'; ?>" alt="" />

									<?php } ?>

								</div>

								<p class="review-content"><?php echo $slider_info['reviewer_message']; ?></p>

								<div class="review-author">
									<img src="<?php echo $slider_info['reviewer_image']; ?>" alt="" />

									<div class="review-author-content">
										<h6><?php echo $slider_info['reviewer_name']; ?></h6>
										<span><?php echo $slider_info['reviewer_ocupation']; ?></span>
									</div>
								</div>
							</div>
						</div>

						<div class="message-bubble message-bubble-left">
							<div class="user">
								<img src="<?php echo $slider_info['employer_image']; ?>" alt="" />
								<span><?php echo $slider_info['employer_name']; ?></span>
							</div>
							<div class="text"><?php echo $slider_info['employer_message']; ?></div>
						</div>

						<div class="message-bubble message-bubble-right">
							<div class="category-text"><span>&bull;</span><?php echo $slider_info['category_name']; ?></div>
							<div class="title"><?php echo $slider_info['category_job_name']; ?></div>
							<div class="bottom">
								<div class="perks">
									<div class="perk"><?php echo $levels_arr[array_rand( $levels_arr, 1 )]; ?></div>
									<div class="perk"><?php echo ucfirst( wpj_translate_string( $price_type_arr[array_rand( $price_type_arr, 1 )] ) ); ?></div>
								</div>

								<div class="price"><?php echo wpj_show_price( rand( 1, 99 ), 0 ); ?></div>
							</div>
						</div>
					</div>
				</div>

			<?php }
		} ?>

	</div>

	<div class="main-content cf">

		<?php wpj_display_search_with_categories(); ?>

	</div>

</div>
