<?php
/**
 * @var $slider_elements
 * @var $pid
 * @var $video_arr
 * @var $images_arr
 * @var $review_samples
 * @var $preview
 */
?>

<div class="cf">

	<?php // Slider
	if ( $slider_elements > 0 ) { $i = 1; ?>

		<div class="wpj-carousel job-single-slider owl-carousel">

			<?php // Video before images
			if ( get_post_meta( $pid, 'video_as_job_thumbnail', true ) != 'no' ) {
				if ( $video_arr ) {
					foreach ( $video_arr as $key => $value ) {
						if ( $value && wpj_get_video_url_type( $value ) ) { ?>

							<a class="owl-video" data-hash="slide<?php echo $i; ?>" href="<?php echo $value; ?>"></a>

						<?php } $i++;
					}
				}
			}

			// Images
			$counter = 0;
			if ( $images_arr ) {
				foreach ( $images_arr as $image ) {
					$image_src = wpj_get_attachment_image_url( $image->ID, 'job_slider_image' );

					if ( $counter > 0 ) {
						$lazy_class = 'bx-lazy owl-lazy';
						$lazy_src = get_template_directory_uri() . '/assets/images/media/blank.gif';

					} else {
						$lazy_class = '';
						$lazy_src = $image_src;

					} ?>

					<div class="bx-lazy-container" data-hash="slide<?php echo $i; ?>">
						<img src="<?php echo $lazy_src; ?>" class="job-blurry-bg <?php echo $lazy_class; ?>" data-src="<?php echo $image_src; ?>" alt="" />
						<img src="<?php echo $lazy_src; ?>" class="job-slider-img <?php echo $lazy_class; ?>" data-src="<?php echo $image_src; ?>" alt="" />
					</div>

					<?php $counter++; $i++;
				}
			}

			// Video after images
			if ( get_post_meta( $pid, 'video_as_job_thumbnail', true ) == 'no' ) {
				if ( $video_arr ) {
					foreach ( $video_arr as $key => $value ) {
						if ( $value && wpj_get_video_url_type( $value ) ) { ?>

							<a class="owl-video" data-hash="slide<?php echo $i; ?>" href="<?php echo $value; ?>"></a>

						<?php } $i++;
					}
				}
			}

			// Review work samples
			if ( wpj_get_option( 'wpjobster_enable_review_work_samples' ) == 'yes' ) {
				if ( $review_samples ) {
					foreach ( $review_samples as $sample ) {
						$image_src  = wpj_get_attachment_image_url( $sample->sample_id, 'job_slider_image' );
						$lazy_class = 'bx-lazy owl-lazy';
						$lazy_src   = get_template_directory_uri() . '/assets/images/media/blank.gif'; ?>

						<div class="bx-lazy-container" data-hash="slide<?php echo $i; ?>">
							<img src="<?php echo $lazy_src; ?>" class="job-blurry-bg <?php echo $lazy_class; ?>" data-src="<?php echo $image_src; ?>" alt="" />
							<img src="<?php echo $lazy_src; ?>" class="job-slider-img <?php echo $lazy_class; ?>" data-src="<?php echo $image_src; ?>" alt="" />
							<div class="work-sample-caption">
								<blockquote><?php echo $sample->reason; ?></blockquote>
								<small><?php echo sprintf( __( 'Reviewed by %1$s %2$s', "wpjobster" ), wpj_get_user_display_type( $sample->uid ), wpj_seconds_to_words( time() - $sample->datemade, false, true ) ); ?></small>
							</div>
						</div>

						<?php $counter++; $i++;
					}
				}
			} ?>

		</div>

	<?php }

	// Thumbnail preview list
	if ( $slider_elements > 1 && ! $preview ) { $i = 1; ?>

		<div class="image-gallery-slider-pager-container">

			<div class="image-gallery-slider-pager">

				<?php // Video before images
				if ( get_post_meta( $pid, 'video_as_job_thumbnail', true ) != 'no' ) {
					if ( $video_arr ) {
						foreach ( $video_arr as $key => $value ) {
							if ( $value && wpj_get_video_url_type( $value ) ) { ?>

								<a href="#slide<?php echo $i; ?>" class="video-thumbnail">

									<div class="pager-bg-thumb" style="background-image: url('<?php echo wpj_get_video_thumb( $value ); ?>');"></div>

								</a>

							<?php } $i++;
						}
					}
				}

				// Images
				foreach ( $images_arr as $image ) {
					$sliderthumb = wpj_get_attachment_image_url( $image->ID, array( 42, 42 ) ); ?>

					<a href="#slide<?php echo $i; ?>" class="<?php if ( $i == 1 ) echo 'active'; ?>">

						<div class="pager-bg-thumb" style="background-image: url('<?php echo $sliderthumb; ?>');"></div>

					</a>

					<?php $i++;
				}

				// Video after images
				if ( get_post_meta( $pid, 'video_as_job_thumbnail', true ) == 'no' ) {
					if ( $video_arr ) {
						foreach ( $video_arr as $key => $value ) {
							if ( $value && wpj_get_video_url_type( $value ) ) { ?>

								<a href="#slide<?php echo $i; ?>" class="video-thumbnail">

									<div class="pager-bg-thumb" style="background-image: url('<?php echo wpj_get_video_thumb( $value ); ?>');"></div>

								</a>

							<?php } $i++;
						}
					}
				}

				// Review work samples
				if ( wpj_get_option( 'wpjobster_enable_review_work_samples' ) == 'yes' ) {
					if ( $review_samples ) {
						foreach ( $review_samples as $sample ) {
							$sliderthumb = wpj_get_attachment_image_url( $sample->sample_id, array( 42, 42 ) ); ?>

							<a href="#slide<?php echo $i; ?>">

								<div class="pager-bg-thumb" style="background-image: url('<?php echo $sliderthumb; ?>');"></div>

							</a>

							<?php $i++;
						}
					}
				} ?>

			</div>

		</div>

	<?php } ?>

</div>