<?php
/**
 * @var $posts
 * @var $no_image_src
 */

if ( $posts->have_posts() ) { ?>

	<div class="cf cb pr news-stories-wrapper">

		<div class="news-carousel js-news-carousel owl-carousel">

			<?php while ( $posts->have_posts() ) { $posts->the_post(); ?>

				<div class="ui card news-article">

					<a class="article-image" href="<?php the_permalink(); ?>">

						<div class="article-image-holder">

							<?php if ( get_the_post_thumbnail( get_the_ID(), 'news_slider' ) ) {

								echo get_the_post_thumbnail( get_the_ID(), 'news_slider' );

							} else { ?>

								<img alt="no avatar" class="no-border pv11h0" src="<?php echo $no_image_src; ?>" />

							<?php } ?>

						</div>

						<div class="article-postdate">

							<i class="calendar alternate outline icon"></i><?php echo get_the_date( wpj_get_option( 'date_format' ) ); ?>

						</div>

					</a>

					<div class="article-content">

						<a class="article-title" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>

						<div class="article-description"><?php echo wpj_trim( wp_strip_all_tags( get_the_excerpt(), true ), 240 ); ?></div>

					</div>

				</div>

			<?php }

			wp_reset_query(); ?>

		</div>

	</div>

<?php } else { ?>

	<div><?php _e( 'No posts.', 'wpjobster' ); ?></div>

<?php }