<?php
/**
 * @var $posts
 * @var $no_image_src
 */
?>

<div class="news-slider-wrapper">

	<div class="owl-carousel js-news-hero-slider">

		<?php if ( $posts->have_posts() ) {

			while ( $posts->have_posts() ) { $posts->the_post();

				if ( get_the_post_thumbnail( get_the_ID(), 'news_slider' ) ) { ?>

					<div class="news-slide" style="background-image: url(<?php echo get_the_post_thumbnail_url( get_the_ID(), 'full' ); ?>)">

				<?php } else { ?>

					<div class="news-slide" style="background-image: url(<?php echo $no_image_src; ?>)">

				<?php } ?>

					<div class="text-content">

						<h2><a href="#" title=""><?php the_title(); ?></a></h2>

						<div class="postdate"><?php echo get_the_date( wpj_get_option( 'date_format' ) ); ?></div>

					</div>

				</div>

			<?php }

			wp_reset_query();

		} else {

			for ( $i = 1; $i <= 3; $i++ ) { ?>

				<div class="news-slide" style="background-image: url(<?php echo get_template_directory_uri() . '/assets/images/dummy/news-slide' . $i . '.webp'; ?>)">

					<div class="text-content">

						<h2><a href="#" title=""><?php _e( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'wpjobster' ); ?></a></h2>

						<div class="postdate"><?php _e( '24 November, 2021', 'wpjobster' ); ?></div>

					</div>

				</div>

			<?php }

		} ?>

	</div>

</div>