<?php
/**
 * @var $reviews
 */

if ( $reviews ) { ?>

	<div class="user-reviews-carousel js-user-reviews-carousel owl-carousel">

		<?php foreach ( $reviews as $key => $review ) { ?>

			<div class="slide-item">

				<a href="<?php echo wpj_get_user_profile_link( $review->uid ); ?>" class="avatar" title="">

					<?php wpj_display_user_photo( array( 'uid' => $review->uid, 'width' => 80, 'height' => 80, 'with_level_image' => false, 'with_link' => false ) ); ?>

				</a>

				<div class="review-content">

					<div class="review-content-header">

						<a href="<?php echo wpj_get_user_profile_link( $review->uid ); ?>" class="title" title="">

							<?php echo wpj_get_user_display_type( $review->uid ); ?>

						</a>

						<div class="star-rating">

							<?php wpj_display_rating_stars( $review->grade ); ?>

						</div>

					</div>

					<div class="review-content-text">

						<?php echo wpj_apply_filter_to_string( wpj_stripslashes( str_replace( '\n', '<br>', $review->reason ) ), false, 'userprofiles' ); ?>

					</div>

				</div>

			</div>

		<?php } ?>

	</div>

<?php } else echo '<style>.job-user-feedback-row-wrapper, .job-user-reviews-carousel-wrapper{display:none;}</style>'; // for page builder