<?php
/**
 * @var $select_name
 * @var $select_class
 * @var $big
 * @var $select_id
 * @var $select_multiple
 * @var $include_empty_option
 * @var $terms
 * @var $term_type
 * @var $select_value
 * @var $taxonomy_name
 */
?>

<select name="<?php echo esc_attr( $select_name ); ?>" class="ui selection fluid search full-text-search dropdown clearable <?php echo esc_attr( $select_class ); ?> <?php echo ( $big ) ? 'search-select-big' : ''; ?>" id="<?php echo esc_attr( $select_id ); ?>" <?php echo esc_attr( $select_multiple ); ?>>

	<?php if ( $include_empty_option ) { ?>

		<option value=""><?= esc_html( $include_empty_option ); ?></option>

	<?php }

	if ( ! function_exists( 'wpj_display_terms_recursively' ) ) {
		function wpj_display_terms_recursively( $terms, $term_type, $select_value, $taxonomy_name, $indentation = '' ) {
			foreach ( $terms as $term ) {
				$option_value = ( $term_type == 'slug' ) ? $term->slug : ( ( $term_type == 'id' ) ? $term->term_id : $term->name );

				if ( is_array( $select_value ) ) {
					$selected = in_array( $option_value, $select_value ) ? "selected='selected'" : '';

				} else {
					$selected = ( $select_value == $option_value ) ? "selected='selected'" : '';

				} ?>

				<option <?php echo esc_attr( $selected ); ?> value="<?php echo esc_attr( $option_value ); ?>"><?php echo esc_html( $indentation . $term->name ); ?></option>

				<?php $child_terms = get_terms( $taxonomy_name, "orderby=name&order=ASC&hide_empty=0&parent=" . $term->term_id );

				if ( $child_terms ) {
					wpj_display_terms_recursively( $child_terms, $term_type, $select_value, $taxonomy_name, $indentation . '&nbsp;&nbsp;&#8227;&nbsp;' );
				}
			}
		}
	}

	wpj_display_terms_recursively( $terms, $term_type, $select_value, $taxonomy_name ); ?>

</select>