<?php
/**
 * @var $terms
 * @var $parents_without_children
 */

if ( $terms ) { ?>

	<div class="ui four column doubling stackable grid">

		<?php foreach ( $terms as $term ) {

			if ( ! $parents_without_children && ! get_term_children( $term->term_id, 'job_cat' ) ) continue; ?>

			<div class="column">

				<div class="categories-list">

					<a class="category-title" href="<?php echo get_term_link( $term->slug, 'job_cat' ); ?>">

						<?php echo $term->name; ?>

						<div class="category-count"><?php echo $term->count; ?></div>

					</a>

					<?php if ( ! function_exists( 'wpj_display_subcategories_recursively' ) ) {

						function wpj_display_subcategories_recursively( $term_id, $taxonomy, $indent = 0 ) {

							$terms = get_terms( $taxonomy, 'parent=' . $term_id . '&hide_empty=0' );

							if ( $terms ) { ?>

								<div class="subcategory-list">

									<?php foreach ( $terms as $term ) { ?>

										<div class="item">

											<a href="<?php echo get_term_link( $term->slug, $taxonomy ); ?>">

												<?php echo str_repeat( '&#8227;&nbsp;', $indent ) . $term->name; ?>

												<div class="category-count">

													<?php echo $term->count; ?>

												</div>

											</a>

											<?php wpj_display_subcategories_recursively( $term->term_id, $taxonomy, $indent + 1 ); ?>

										</div>

									<?php } ?>

								</div>

							<?php }

						}

					}

					wpj_display_subcategories_recursively( $term->term_id, 'job_cat', 1 ); ?>

				</div>

			</div>

		<?php } ?>

	</div>

<?php } else {

	wpj_display_no_categories_notice_warning();

}