<?php
/**
 * @var $pid
 * @var $payment_type
 * @var $breadcrumbs
 */
?>

<div class="ui breadcrumb payment-job-categories" data-pid="<?php echo $pid; ?>">

	<?php if ( $payment_type == 'custom_extra' ) { ?>

		<p class="mt10">

			<?php echo sprintf(
				__( '%s: %s', 'wpjobster' ),
				apply_filters( 'wpj_custom_extra_string_with_dots_filter', __( 'Custom extra:', 'wpjobster' ) ),
				( ! empty( $custom_extra->description ) ? wpj_apply_filter_to_string( $custom_extra->description, false, 'joblistings' ) : '-' )
			); ?>

		</p>

	<?php } elseif ( $payment_type == 'tips' ) { ?>

		<p class="mt10">
			<?php echo sprintf(
				__( 'Tips: %s', 'wpjobster' ),
				( ! empty( $tip->reason ) ? wpj_apply_filter_to_string( $tip->reason, false, 'joblistings' ) : '-' )
			); ?>

		</p>

	<?php } else {

		foreach ( $breadcrumbs as $index => $breadcrumb ) { ?>

			<?php if ( $index > 0 ) { ?>

				<div class="divider">

					<i class="right chevron icon divider"></i>

				</div>

			<?php } ?>

			<a class="section" href="<?php echo $breadcrumb['link']; ?>">

				<?php echo $breadcrumb['name']; ?>

			</a>

		<?php }

	} ?>

</div>