<?php
/**
 * @var $badges_data
 * @var $user_badge
 * @var $ratings_no
 * @var $reviews_no
 */
?>

<?php if ( wpj_get_option( 'wpjobster_enable_badges_sale' ) == 'yes' && wpj_get_option( 'wpjobster_credits_enable' ) != 'no' && apply_filters( 'hide_for_buyers', true, get_current_user_id() ) ) {

	if ( $badges_data && is_array( $badges_data ) ) { ?>

		<ul class="payment-items-list">

			<?php foreach ( $badges_data['redux_repeater_data'] as $key => $badge ) {

				$min_ratings_no = $badges_data['wpj_badge_min_rating'][$key] ? $badges_data['wpj_badge_min_rating'][$key] : 0;
				$min_reviews_no = $badges_data['wpj_badge_min_reviews'][$key] ? $badges_data['wpj_badge_min_reviews'][$key] : 0; ?>

				<li class="cf vertical-align-middle">

					<?php if ( $user_badge && in_array( $key, $user_badge ) ) {

						echo $badges_data['wpj_badge_text'][$key]; ?>

						<span class="payment-item-price">

							<?php if ( false === has_action( 'wpj_after_purchased_badge_checkmark' ) ) { ?>

								<i class="check icon"></i>

							<?php }

							do_action( 'wpj_after_purchased_badge_checkmark', ( wpj_get_badge_order( 'id', ['badge_nr' => $key, 'user_id' => get_current_user_id()], 'var' ) ?: $key ) ); ?>

							<input style="display: none;" type="checkbox" name="badges_bought[]" value="<?php echo $key; ?>" checked="checked" />

						</span>

					<?php } elseif ( $ratings_no >= $min_ratings_no && $reviews_no >= $min_reviews_no ) { ?>

						<div class="ui radio checkbox">

							<input type="radio" class="styled badge_chk" data-price="<?php echo wpj_number_format_special_exchange( $badges_data['wpj_badge_price'][$key], 1, wpj_get_site_currency() ); ?>" name="badges" id="badges_chk_<?php echo $key; ?>" value="<?php echo $key; ?>" />

							<label><?php echo $badges_data['wpj_badge_text'][$key]; ?></label>

						</div>

						<span class="payment-item-price"><?php echo wpj_show_price( $badges_data['wpj_badge_price'][$key] ); ?></span>

					<?php } else {

						echo $badges_data['wpj_badge_text'][$key]; ?>

						<span class="payment-item-price">

							<?php echo sprintf( __( 'In order to buy this badge you must have at least %s for rating numbers and a minimum of %s reviews.', 'wpjobster' ), $min_ratings_no, $min_reviews_no ); ?>

						</span>

					<?php } ?>

				</li>

			<?php } ?>

		</ul>

	<?php } else echo '<style>.badge-list-row-wrapper{display:none;}</style>'; // for page builder

} else echo '<style>.badge-list-row-wrapper{display:none;}</style>'; // for page builder