<?php
/**
 * @var $payment_type
 * @var $pid
 * @var $default_package
 * @var $default_price
 * @var $default_delivery
 * @var $display_location
 * @var $tabs_slug
 */
?>

<form class="ui form" method="post" name="myFormPurchase" action="<?php echo get_permalink( wpj_get_option( 'wpjobster_checkout_page_id' ) ); ?>">

<!-- HIDDEN POST VALUES -->
	<?php if ( $payment_type == 'job_purchase' ) { ?>

		<input type="hidden" name="jobid" value="<?php echo $pid; ?>" />

		<?php if ( get_post_meta( $pid, 'job_packages', true ) == 'yes' ) { ?>

			<input type="hidden" name="package_no" value="<?php echo WPJ_Form::post( 'package_no', $default_package ); ?>" class="package_no" />
			<input type="hidden" name="package_price" value="<?php echo WPJ_Form::post( 'package_price', $default_price ); ?>" class="package_price" />
			<input type="hidden" name="package_delivery_days" value="<?php echo WPJ_Form::post( 'package_delivery_days', $default_delivery ); ?>" class="package_delivery_days" />

		<?php }

	} elseif ( $payment_type == 'custom_extra' ) { ?>

		<input type="hidden" name="oid" value="<?php echo WPJ_Form::request( 'oid' ); ?>" />
		<input type="hidden" name="custom_extra" value="<?php echo WPJ_Form::request( 'custom_extra' ); ?>" />

	<?php } elseif ( $payment_type == 'tips' ) { ?>

		<input type="hidden" name="oid" value="<?php echo WPJ_Form::request( 'oid' ); ?>" />
		<input type="hidden" name="tips" value="<?php echo WPJ_Form::request( 'tips' ); ?>" />

	<?php }

	if ( isset( $_POST['trp-edit-translation'] ) ) { ?>

		<input type="hidden" name="trp-edit-translation" value="<?php echo $_POST['trp-edit-translation']; ?>" />

	<?php } ?>

	<input type="hidden" name="purchaseformvalidation" value="ok" />

<!-- SIDEBAR -->
	<?php if ( $display_location == 'sidebar' ) { ?>

		<!-- TABS -->
		<div class="ui menu top">

			<?php if ( get_post_meta( $pid, 'job_packages', true ) == 'yes' ) {
				foreach ( $tabs_slug as $pck_nr => $tab_slug ) { ?>

					<a
						class="item pck-sidebar-select-package <?php echo $pck_nr . ( $default_package == $pck_nr ? ' active' : '' ); ?>"
						data-price="<?php echo wpj_number_format_special_exchange( get_post_meta( $pid, 'package_price', true )[$pck_nr] ); ?>"
						data-price-formatted="<?php echo wpj_show_price( get_post_meta( $pid, 'package_price', true )[$pck_nr] ); ?>"
						data-delivery="<?php echo get_post_meta( $pid, 'package_max_days', true )[$pck_nr]; ?>"
						data-tab="<?php echo $tab_slug; ?>-info"
					>

						<?php
						if ( $pck_nr == 0 ) _e( 'Basic', 'wpjobster' );
						if ( $pck_nr == 1 ) _e( 'Standard', 'wpjobster' );
						if ( $pck_nr == 2 ) _e( 'Premium', 'wpjobster' );
						?>

					</a>

				<?php }

			} else { ?>

				<a class="active item" data-tab="basic-info"><?php _e( 'Basic', 'wpjobster' ); ?></a>
				<a class="item" data-tab="extra-info"><?php _e( 'Extra', 'wpjobster' ); ?></a>

			<?php } ?>

		</div>

		<!-- DEFAULT TABS CONTENT -->
		<?php if ( get_post_meta( $pid, 'job_packages', true ) != 'yes' ) { ?>

			<!-- BASIC TAB CONTENT -->
			<div class="ui tab active" data-tab="basic-info">

				<?php if ( $payment_type == 'job_purchase' ) {

					// Basic job info
					wpj_display_job_basic_details( $pid, 'sidebar' );

					// Quantity
					wpj_display_job_quantity_details( $pid, 'sidebar_basic' );

					// Shipping
					wpj_display_job_order_extra_details( $pid, 'sidebar', 'shipping' );

					// Processing fees
					wpj_display_job_order_extra_details( $pid, 'sidebar', 'processing_fees' );

					// Tax
					wpj_display_job_order_extra_details( $pid, 'sidebar', 'tax' );

				} ?>

				<!-- Buy button -->
				<div class="single-job-sidebar-padded-content mb-6"><?php wpj_display_job_order_button(); ?></div>

			</div>

			<!-- EXTRA TAB CONTENT -->
			<div class="ui tab" data-tab="extra-info">

				<!-- Quantity -->
				<?php if ( $payment_type == 'job_purchase' ) wpj_display_job_quantity_details( $pid, 'sidebar_extra' ); ?>

				<!-- Extras -->
				<?php wpj_display_job_order_extra_details( $pid, 'sidebar' ); ?>

				<!-- Buy button -->
				<div class="single-job-sidebar-padded-content"><?php wpj_display_job_order_button(); ?></div>

			</div>

		<?php } ?>

		<!-- PACKAGES TABS CONTENT -->
		<?php if ( $payment_type == 'job_purchase' && get_post_meta( $pid, 'job_packages', true ) == 'yes' ) {

			foreach ( $tabs_slug as $pck_nr => $tab_slug ) { ?>

				<div class="ui tab <?php if ( $pck_nr == $default_package ) echo 'active'; ?>" data-tab="<?php echo $tab_slug; ?>-info">

					<?php // Basic job info
					wpj_display_job_basic_details( $pid, 'sidebar', $pck_nr );

					// Package info
					wpj_display_packages_details( $pid, $pck_nr );

					// Quantity
					wpj_display_job_quantity_details( $pid, 'sidebar_basic', $pck_nr );

					// Extras
					wpj_display_job_order_extra_details( $pid, 'sidebar' ); ?>

					<!-- Buy button -->
					<div class="single-job-sidebar-padded-content"><?php wpj_display_job_order_button(); ?></div>

				</div>

			<?php }

		} ?>

<!-- ORDER ADDITIONAL -->
	<?php } else {

		// Quantity
		if ( $payment_type == 'job_purchase' ) wpj_display_job_quantity_details( $pid, ( is_singular( 'job' ) ? 'order_additional' : 'checkout' ) );

		// Extras
		wpj_display_job_order_extra_details( $pid, ( is_singular( 'job' ) ? 'order_additional' : 'checkout' ) );

	} ?>

</form>