<?php
/**
 * @var $payment_type
 * @var $is_post_author
 * @var $author_vacation
 * @var $pid
 * @var $include_credits
 * @var $is_enough_credit
 * @var $credits_only
 * @var $error_msg
 */
?>

<div class="payment-buttons">

	<?php // Account Balance / Free
	if (
		(
			( $payment_type == 'job_purchase' && ! $is_post_author && ! $author_vacation && get_post_meta( $pid, 'active', true ) == 1 )
			|| wpj_is_custom_offer( $pid )
			|| $payment_type != 'job_purchase'
		)
		&& $include_credits
	) {

		if ( ! wpj_is_payment_free( $payment_type ) ) { // Account Balance

			do_action( 'wpj_before_account_balance_button', $pid );

			if ( wpj_get_option( 'wpjobster_credits_enable' ) != 'no' && $is_enough_credit ) { ?>

				<div onclick='take_to_gateway( "credits", "<?php echo $payment_type; ?>" );' class="text-button light js-credits" id="credits">

					<?php echo sprintf( __( 'Account Balance - %s', 'wpjobster' ), wpj_show_price( wpj_get_user_credit( get_current_user_id() ) ) ); ?>

				</div>

			<?php } elseif ( wpj_get_option( 'wpjobster_credits_enable' ) != 'no' && ! $is_enough_credit ) { ?>

				<div class="text-button light js-credits" id="credits" data-tooltip="You don't have enough money in your balance!" data-position="right center" data-inverted="">

					<?php echo sprintf( __( 'Account Balance - %s', 'wpjobster' ), wpj_show_price( wpj_get_user_credit( get_current_user_id() ) ) ); ?>

				</div>

			<?php }

			do_action( 'wpj_after_account_balance_button', $pid );

		}

	}

	// Gateways
	if (
		(
			( $payment_type == 'job_purchase' && ! $is_post_author && ! $author_vacation && get_post_meta( $pid, "active", true ) == 1 )
			|| wpj_is_custom_offer( $pid )
			|| $payment_type != 'job_purchase'
		)
		&& wpj_get_payment_gateways()
		&& ! $credits_only
	) {

		foreach ( wpj_get_payment_gateways() as $priority => $gateway ) {

			if ( wpj_is_payment_type_enabled( $gateway['unique_id'], $payment_type ) && empty( $gateway['no_pay_button'] ) ) { $gateway_enabled = true;

				if ( $gateway['unique_id'] == 'cod' && ! wpj_is_COD_payment_allowed( $pid, $payment_type ) ) { $gateway_enabled = false; continue; } // if COD allowed

				do_action( 'wpj_before_' . $gateway['unique_id'] . '_' . $payment_type . '_button', $pid ); ?>

				<a
					onclick='take_to_gateway( "<?php echo $gateway['unique_id']; ?>", "<?php echo $payment_type; ?>" );'
					class="text-button light cursor-pointer <?php echo $payment_type . ' js-' . $gateway['unique_id']; ?>"
					id="<?php echo $gateway['unique_id']; ?>"
					<?php if ( wpj_is_payment_free( $payment_type ) ) { echo ' style="display: none;"'; } ?>
				>

					<?php echo wpj_get_option( 'wpjobster_' . $gateway['unique_id'] . '_button_caption' ) ? wpj_get_option( 'wpjobster_' . $gateway['unique_id'] . '_button_caption' ) : $gateway['unique_id']; ?>

				</a>

				<?php do_action( 'wpj_after_' . $gateway['unique_id'] . '_' . $payment_type . '_button', $pid );

			}
		}
	}

	if ( $error_msg ) { ?>

		<div class="ui payment-method-error label">
			<p><?php echo $error_msg; ?></p>
		</div>

	<?php } ?>

</div>

<?php if ( wpj_is_payment_free( $payment_type ) ) { // Free ?>

	<div class="free-btn">
		<div onclick='take_to_gateway( "credits", "<?php echo $payment_type; ?>" );' class="text-button light js-credits" id="credits"><?php _e( 'Get for free', 'wpjobster' ); ?></div>
	</div>

<?php }