<?php
/**
 * @var $default_gateways
 * @var $uid
 */
?>

<form class="ui form" method="post" enctype="application/x-www-form-urlencoded">

	<div class="wpj-dashboard-table-wrapper js-wpj-table-wrapper">

		<div class="ui stackable grid wpj-grid-table list-wrapper wpj-dashboard-table">

			<?php if ( wpj_withdrawal_gateway_enabled_exist() ) { ?>

				<div class="row computer tablet only wpj-dashboard-table-header">

					<div class="eight wide column table-header-title">
						<div class="table-label"><?php _e( 'Method', 'wpjobster' ); ?></div>
					</div>

					<div class="four wide column table-header-title">
						<div class="table-label"><?php _e( 'Withdraw amount', 'wpjobster' ); ?></div>
					</div>

					<div class="four wide column table-header-title">
						<div class="table-label"><?php _e( 'Action', 'wpjobster' ); ?></div>
					</div>

				</div>

				<div class="row special cf">

					<!-- Gateways -->
					<?php if ( $default_gateways ) {

						foreach ( $default_gateways as $key => $gateway ) {

							if ( $gateway['meta'] ) { ?>

								<div class="ui stackable grid item-content">

									<div class="eight wide column">
										<div class="withdraw-title">
											<?php echo $gateway['label']; ?>
										</div>
									</div>

									<div class="four wide column">
										<div class="ui labeled input">
											<label class="ui label"><?php echo apply_filters( 'wpj_withdrawal_currency_label_filter', wpj_get_currency_symbol_by_name( wpj_get_site_currency() ), $gateway ); ?></label>
											<input value="<?php if ( isset( $_POST['amount'] ) && isset( $_POST[$gateway['name'] . '_withdraw'] ) ) echo $_POST['amount']; ?>" type="text" size="10" name="amount" />
										</div>

										<input value="<?php echo get_user_meta( $uid, $gateway['name'] . '_email', true ); ?>" type="hidden" name="email" />
										<input value="<?php echo get_user_meta( $uid, $gateway['name'] . '_email', true ); ?>" type="hidden" name="details" />
										<input value="<?php _e( 'Withdraw', 'wpjobster' ); ?>" type="hidden" name="<?php echo $gateway['name']; ?>_withdraw" />

										<?php if ( $gateway['name'] == 'payoneer' ) { ?>

											<input value="<?php echo apply_filters( 'wpj_payoneer_details_filter', get_user_meta( $uid, 'payoneer_email', true ) ); ?>" type="hidden" size="30" name="details" />

										<?php }

										do_action( 'wpj_after_withdrawal_gateways_list_details_input', $gateway ); ?>

									</div>

									<div class="four wide column">
										<a class="ui button secondary no-margin fluid js-request-withdrawal"><?php _e( 'Withdraw', 'wpjobster' ); ?></a>
									</div>

								</div>

							<?php } else { ?>

								<div class="ui stackable grid item-content">

									<div class="eight wide column">

										<?php echo $gateway['label']; ?>

									</div>

									<div class="eight wide column">

										<?php echo sprintf( __( 'Please fill your %s information <a class="fill-payment-color" href="%s">here</a>.', 'wpjobster' ), $gateway['label'], get_permalink( wpj_get_option( 'wpjobster_my_account_personal_info_page_id' ) ) . 'payments' ); ?>

									</div>

								</div>

							<?php }
						}

					} ?>

				</div>

			<?php } else { ?>

				<div class="sixteen wide column">

					<?php _e( 'No withdrawal method is available on this site. Please contact the administrator.', 'wpjobster' ); ?>

				</div>

			<?php } ?>

		</div>

	</div>

</form>