<?php
/**
 * @var $topup_packages
 * @var $currency
 */
?>

<div class="wpj-dashboard-table-wrapper js-wpj-table-wrapper wpj-dashboard-topup-table">

	<div class="ui stackable grid wpj-grid-table list-wrapper wpj-dashboard-table">

		<?php if ( wpj_get_option( 'wpjobster_enable_topup' ) == 'yes' && wpj_get_option( 'wpjobster_credits_enable' ) == 'yes' ) {

			if ( is_array( $topup_packages['topup_cost'] ) && count( array_filter( $topup_packages['topup_cost'] ) ) > 0 ) { ?>

				<div class="row computer tablet only wpj-dashboard-table-header">

					<div class="eight wide column table-header-title">
						<div class="table-label"><?php _e( 'Cost', 'wpjobster' ); ?></div>
					</div>

					<div class="eight wide column table-header-title">
						<div class="table-label"><?php _e( 'Credits', 'wpjobster' ); ?></div>
					</div>

				</div>

				<div class="row special cf">

					<?php foreach ( $topup_packages['redux_repeater_data'] as $key => $row ) { ?>

						<div class="ui grid item-content">

							<div class="eight wide column">
								<div class="topup-title">
									<?php _e( 'Cost', 'wpjobster' ); ?>
								</div>

								<div class="ui radio checkbox">
									<input class="topup_chk" id="credit_amt<?php echo $key; ?>" type="radio" data-price="<?php echo wpj_number_format_special_exchange( $topup_packages['topup_cost'][$key], 1, $currency ); ?>" name="topup" value="<?php echo $key; ?>">
									<label for="credit_amt<?php echo $key; ?>"><?php echo wpj_show_price( $topup_packages['topup_cost'][$key], 2 ); ?></label>
								</div>
							</div>

							<div class="eight wide column">
								<div class="topup-title">
									<?php _e( 'Credits', 'wpjobster' ); ?>
								</div>

								<label for="credit_amt<?php echo $key; ?>"><?php echo wpj_show_price( $topup_packages['topup_credit'][$key], 2 ); ?></label>
							</div>

						</div>

					<?php } ?>

				</div>

			<?php } else { ?>

				<div class="sixteen wide column">
					<p><?php _e( 'No packages added yet.', 'wpjobster' ); ?></p>
				</div>

				<style>.topup-payment-buttons-row-wrapper{display:none;}</style><!-- for page builder -->

			<?php }

		} else { ?>

			<div class="sixteen wide column">
				<p><?php _e( 'Topup is not available at this time. Please contact the administrator of this site for help.', 'wpjobster' ); ?></p>
			</div>

			<style>.topup-payment-buttons-row-wrapper{display:none;}</style><!-- for page builder -->

		<?php } ?>

	</div>

</div>

