<?php
/**
 * @var $category_featured
 * @var $c_start_date
 * @var $c_end_date
 * @var $category_row
 * @var $homepage
 * @var $subcategory
 * @var $category_price_unformatted
 * @var $category_price_formatted
 * @var $pid
 * @var $uid
 */

if ( wpj_get_option( 'wpjobster_category_featured_enable' ) != 'no' ) {

	if ( $category_featured == 'z' || $category_featured == false ) { ?>

		<input type="hidden" name="c_date_start" value="<?php echo $c_start_date; ?>" />
		<input type="hidden" name="c_end_date"   value="<?php echo $c_end_date; ?>" />

		<?php if ( $category_row ) { // CATEGORY - PENDING PAYMENT

			echo sprintf(
				__( '(Pending) Featured on Category between: <strong>%s - %s</strong>)', 'wpjobster' ),
				wpj_date( wpj_get_option( 'date_format' ), $category_row->c_date_start ),
				wpj_date( wpj_get_option( 'date_format' ), wpj_get_featured_end_date( $category_row->c_date_start ) )
			); ?>

			<div class="mt10">
				<div class="ui mini buttons">

					<button class="ui negative button" onclick="event.preventDefault(); take_to_gateway_feature_process( 'cancel', '<?php echo $category_row->id; ?>', '<?php echo $category_row->payment_gateway_name; ?>' );">

						<?php _e( 'Cancel', 'wpjobster' ); ?>

					</button>

					<?php if ( $category_row->payment_gateway_name != 'banktransfer' && apply_filters( 'wpj_show_process_link_order_page_filter', true, $category_row->payment_gateway_name ) ) { ?>

						<div class="or" data-text="<?php _e( 'or', 'wpjobster' ); ?>"></div>

						<button class="ui positive button" onclick="event.preventDefault(); take_to_gateway_feature_process( 'process', '<?php echo $category_row->id; ?>', '<?php echo $category_row->payment_gateway_name; ?>' )">

							<?php _e( 'Process', 'wpjobster' ); ?>

						</button>

					<?php } ?>

				</div>

				<?php if ( $homepage && $subcategory ) {
					_e( '(includes the cancellation of the homepage and subcategory)', 'wpjobster' );

				} elseif ( $homepage ) {
					_e( '(includes the cancellation of the homepage)', 'wpjobster' );

				} elseif ( $subcategory ) {
					_e( '(includes the cancellation of the subcategory)', 'wpjobster' );

				} ?>

			</div>

			<span class="payment-item-price mt-35">

				<?php echo wpj_show_price( $category_row->payable_amount ); ?>

			</span>

			<?php if ( $category_row->payment_gateway_name == 'banktransfer' ) { ?>

				<div class="ui segment">
					<strong><?php _e( 'Bank Details:', 'wpjobster' ); ?></strong><br>

					<?php wpj_display_bank_details(); ?><br>
				</div>

			<?php }

		} else { // CATEGORY - NEW FEATURED ?>

			<div class="ui checkbox payment-item-title">
				<input type="checkbox" class="styled featured_chk" name="feature_pages[]" data-price="<?php echo wpj_number_format_special_exchange( $category_price_unformatted, 1,  wpj_get_site_currency() ); ?>" id="category_featured_chk" value="category" />

				<label>
					<?php echo sprintf(
						__( 'Category <span>(first available:</span>&nbsp;%s - %s<span>)</span>', 'wpjobster' ),
						wpj_date( wpj_get_option( 'date_format' ), $c_start_date ),
						wpj_date( wpj_get_option( 'date_format' ), $c_end_date )
					); ?>
				</label>
			</div>

			<span class="payment-item-price">

				<?php echo $category_price_formatted; ?>

			</span>

		<?php }

	} else { // CATEGORY - ALREADY FEATURED

		echo sprintf(
			__( 'Featured on Category between: <strong>%s - %s</strong>', 'wpjobster' ),
			wpj_date( wpj_get_option( 'date_format' ), wpj_get_featured_start_date_from_end_date( $category_featured ) ),
			wpj_date( wpj_get_option( 'date_format' ), $category_featured )
		);

		do_action( 'wpj_after_featured_category_info', wpj_get_feature_job_by_page( 'c', $pid, $uid, 'completed' ) );

	}

} else {
	echo '<style>.featured-category-spacer, .featured-category-row-wrapper{display:none;}</style>'; // for page builder

}