<?php
/**
 * @var $home_featured
 * @var $h_start_date
 * @var $h_end_date
 * @var $homepage_row
 * @var $category
 * @var $subcategory
 * @var $homepage_price_unformatted
 * @var $homepage_price_formatted
 * @var $pid
 * @var $uid
 */

if ( wpj_get_option( 'wpjobster_homepage_featured_enable' ) != 'no' ) {

	if ( $home_featured == 'z' || $home_featured == false ) { ?>

		<input type="hidden" name="h_date_start" value="<?php echo $h_start_date; ?>" />
		<input type="hidden" name="h_end_date"   value="<?php echo $h_end_date; ?>" />

		<?php if ( $homepage_row ) { // HOMEPAGE - PENDING PAYMENT

			echo sprintf(
				__( '(Pending) Featured on Homepage between: <strong>%s - %s</strong>)', 'wpjobster' ),
				wpj_date( wpj_get_option( 'date_format' ), $homepage_row->h_date_start ),
				wpj_date( wpj_get_option( 'date_format' ), wpj_get_featured_end_date( $homepage_row->h_date_start ) )
			); ?>

			<div class="mt10">
				<div class="ui mini buttons">

					<button class="ui negative button" onclick="event.preventDefault(); take_to_gateway_feature_process( 'cancel', '<?php echo $homepage_row->id; ?>', '<?php echo $homepage_row->payment_gateway_name; ?>' );">

						<?php _e( 'Cancel', 'wpjobster' ); ?>

					</button>

					<?php if ( $homepage_row->payment_gateway_name != 'banktransfer' && apply_filters( 'wpj_show_process_link_order_page_filter', true, $homepage_row->payment_gateway_name ) ) { ?>

						<div class="or" data-text="<?php _e( 'or', 'wpjobster' ); ?>"></div>

						<button class="ui positive button" onclick="event.preventDefault(); take_to_gateway_feature_process( 'process', '<?php echo $homepage_row->id; ?>', '<?php echo $homepage_row->payment_gateway_name; ?>' )">

							<?php _e( 'Process', 'wpjobster' ); ?>

						</button>

					<?php } ?>

				</div>

				<?php if ( $category && $subcategory ) {
					_e( '(includes the cancellation of the category and subcategory)', 'wpjobster' );

				} elseif ( $category ) {
					_e( '(includes the cancellation of the category)', 'wpjobster' );

				} elseif ( $subcategory ) {
					_e( '(includes the cancellation of the subcategory)', 'wpjobster' );

				} ?>

			</div>

			<span class="payment-item-price mt-35">

				<?php echo wpj_show_price( $homepage_row->payable_amount ); ?>

			</span>

			<?php if ( $homepage_row->payment_gateway_name == 'banktransfer' ) { ?>

				<div class="ui segment">
					<strong><?php _e( 'Bank Details:', 'wpjobster' ); ?></strong><br>

					<?php wpj_display_bank_details(); ?><br>
				</div>

			<?php }

		} else { // HOMEPAGE - NEW FEATURED ?>

			<div class="ui checkbox payment-item-title">
				<input type="checkbox" class="styled featured_chk" name="feature_pages[]" data-price="<?php echo wpj_number_format_special_exchange( $homepage_price_unformatted, 1,  wpj_get_site_currency() ); ?>" id="homepage_featured_chk" value="homepage" />

				<label>
					<?php echo sprintf(
						__( 'Homepage <span>(first available:</span>&nbsp;%s - %s<span>)</span>', 'wpjobster' ),
						wpj_date( wpj_get_option( 'date_format' ), $h_start_date ),
						wpj_date( wpj_get_option( 'date_format' ), $h_end_date )
					); ?>
				</label>
			</div>

			<span class="payment-item-price">

				<?php echo $homepage_price_formatted; ?>

			</span>

		<?php }

	} else { // HOMEPAGE - ALREADY FEATURED

		echo sprintf(
			__( 'Featured on homepage between: <strong>%s - %s</strong>', 'wpjobster' ),
			wpj_date( wpj_get_option( 'date_format' ), wpj_get_featured_start_date_from_end_date( $home_featured ) ),
			wpj_date( wpj_get_option( 'date_format' ), $home_featured )
		);

		do_action( 'wpj_after_featured_homepage_info', wpj_get_feature_job_by_page( 'h', $pid, $uid, 'completed' ) );

	}

} else {
	echo '<style>.featured-homepage-spacer, .featured-homepage-row-wrapper{display:none;}</style>'; // for page builder

}