<?php
/**
 * @var $subcategory_featured
 * @var $s_start_date
 * @var $s_end_date
 * @var $subcategory_row
 * @var $homepage
 * @var $category
 * @var $subcategory_price_unformatted
 * @var $subcategory_price_formatted
 * @var $pid
 * @var $uid
 */

if ( wpj_get_option( 'wpjobster_subcategory_featured_enable' ) != 'no' ) {

	if ( $subcategory_featured == 'z' || $subcategory_featured == false ) { ?>

		<input type="hidden" name="s_date_start" value="<?php echo $s_start_date; ?>" />
		<input type="hidden" name="s_end_date"   value="<?php echo $s_end_date; ?>" />

		<?php if ( $subcategory_row ) { // SUBCATEGORY - PENDING PAYMENT

			echo sprintf(
				__( '(Pending) Featured on Subcategory between: <strong>%s - %s</strong>)', 'wpjobster' ),
				wpj_date( wpj_get_option( 'date_format' ), $subcategory_row->s_date_start ),
				wpj_date( wpj_get_option( 'date_format' ), wpj_get_featured_end_date( $subcategory_row->s_date_start ) )
			); ?>

			<div class="mt10">
				<div class="ui mini buttons">

					<button class="ui negative button" onclick="event.preventDefault(); take_to_gateway_feature_process( 'cancel', '<?php echo $subcategory_row->id; ?>', '<?php echo $subcategory_row->payment_gateway_name; ?>' );">

						<?php _e( 'Cancel', 'wpjobster' ); ?>

					</button>

					<?php if ( $subcategory_row->payment_gateway_name != 'banktransfer' && apply_filters( 'wpj_show_process_link_order_page_filter', true, $subcategory_row->payment_gateway_name ) ) { ?>

						<div class="or" data-text="<?php _e( 'or', 'wpjobster' ); ?>"></div>

						<button class="ui positive button" onclick="event.preventDefault(); take_to_gateway_feature_process( 'process', '<?php echo $subcategory_row->id; ?>', '<?php echo $subcategory_row->payment_gateway_name; ?>' )">

							<?php _e( 'Process', 'wpjobster' ); ?>

						</button>

					<?php } ?>

				</div>

				<?php if ( $homepage && $category ) {
					_e( '(includes the cancellation of the homepage and category)', 'wpjobster' );

				} elseif ( $homepage ) {
					_e( '(includes the cancellation of the homepage)', 'wpjobster' );

				} elseif ( $category ) {
					_e( '(includes the cancellation of the category)', 'wpjobster' );

				} ?>

			</div>

			<span class="payment-item-price mt-35">

				<?php echo wpj_show_price( $subcategory_row->payable_amount ); ?>

			</span>

			<?php if ( $subcategory_row->payment_gateway_name == 'banktransfer' ) { ?>

				<div class="ui segment">
					<strong><?php _e( 'Bank Details:', 'wpjobster' ); ?></strong><br>

					<?php wpj_display_bank_details(); ?><br>
				</div>

			<?php }

		} else { // SUBCATEGORY - NEW FEATURED ?>

			<div class="ui checkbox payment-item-title">
				<input type="checkbox" class="styled featured_chk" name="feature_pages[]" data-price="<?php echo wpj_number_format_special_exchange( $subcategory_price_unformatted, 1,  wpj_get_site_currency() ); ?>" id="subcategory_featured_chk" value="subcategory" />

				<label>
					<?php echo sprintf(
						__( 'Subcategory <span>(first available:</span>&nbsp;%s - %s<span>)</span>', 'wpjobster' ),
						wpj_date( wpj_get_option( 'date_format' ), $s_start_date ),
						wpj_date( wpj_get_option( 'date_format' ), $s_end_date )
					); ?>
				</label>
			</div>

			<span class="payment-item-price">

				<?php echo $subcategory_price_formatted; ?>

			</span>

		<?php }

	} else { // SUBCATEGORY - ALREADY FEATURED

		echo sprintf(
			__( 'Featured on Subcategory between: <strong>%s - %s</strong>', 'wpjobster' ),
			wpj_date( wpj_get_option( 'date_format' ), wpj_get_featured_start_date_from_end_date( $subcategory_featured ) ),
			wpj_date( wpj_get_option( 'date_format' ), $subcategory_featured )
		);

		do_action( 'wpj_after_featured_subcategory_info', wpj_get_feature_job_by_page( 's', $pid, $uid, 'completed' ) );

	}

} else {
	echo '<style>.featured-subcategory-spacer, .featured-subcategory-row-wrapper{display:none;}</style>'; // for page builder

}