<?php
/**
 * @var $enctype
 * @var $method
 * @var $action_url
 * @var $fields
 * @var $autosubmit
 */

get_header(); ?>

<div class="static-login-box">

	<div class="static-login-box-graphic">

		<img src="<?php echo get_template_directory_uri() . '/assets/images/misc/payment-green.svg'; ?>" alt="Payment" width="60" height="60">

	</div>

	<div class="static-login-box-title">

		<div class="wpj-main-header ">

			<h1><?php _e( 'Redirecting to Payment Page...', 'wpjobster' ); ?></h1>

		</div>

	</div>

	<div class="static-login-box-content">

		<div class="message"><?php _e( 'If you are not automatically redirected to the payment page within 5 seconds...', 'wpjobster' ); ?></div>

		<form id="payment_form" <?php if ( $enctype ) { ?> enctype="<?php echo $enctype; ?>" <?php } ?> name="payment_form" method="<?php echo $method; ?>" action="<?php echo $action_url; ?>">

			<?php if ( $fields ) {

				foreach ( $fields as $name => $value ) { ?>

					<input type="hidden" name="<?php echo $name; ?>" value="<?php echo $value; ?>">

				<?php } ?>

				<input type="submit" class="text-button text-button-secondary" value="<?php _e( 'Click Here', 'wpjobster' ); ?>" />

			<?php } else { ?>

				<a class="text-button text-button-secondary" href="<?php echo $action_url; ?>"><?php _e( 'Click Here', 'wpjobster' ); ?></a>
				<?php if ( $autosubmit ) { ?><script>window.location.href = '<?php echo $action_url; ?>';</script><?php }

			} ?>

		</form>

	</div>

</div>

<?php if ( $autosubmit && $fields ) { ?><script>document.getElementById( "payment_form" ).submit();</script><?php }

get_footer();