<?php
/**
 * @var $table_content
 * @var $table_data
 * @var $tab_name
 * @var $table_header
 * @var $table_no_results_msg
 */

if ( ! $table_content ) {

	if ( $table_data->have_rows() ) { ?>

		<!-- Search from -->
		<?php if ( wpj_get_option( 'wpjobster_enable_user_account_search' ) != 'no'
			&& (
				! isset( $table_data->query_type )
				|| ( isset( $table_data->query_type ) && $table_data->query_type != 'withdrawals' )
			)
		) { ?>

			<div class="ui search wpj-dashboard-table-search js-user-account-search" data-tab-name="<?php echo $tab_name; ?>">

				<div class="ui icon input">

					<input class="prompt" type="text" placeholder="<?php _e( 'Keyword', 'wpjobster' ); ?>" value="">

					<i class="search icon"></i>

				</div>

				<!-- Search results -->
				<div class="results"></div>

				<!-- Fill search results -->
				<script>
					jQuery( document ).ready( function( $ ) {
						if ( $( '.js-user-account-search[data-tab-name="<?php echo $tab_name; ?>"]' )[0] ) {
							$( '.js-user-account-search[data-tab-name="<?php echo $tab_name; ?>"]' ).search({
								source        : $.parseJSON( '<?php echo wpj_stripslashes( json_encode( $table_data->get_search_results_items(), JSON_UNESCAPED_SLASHES ) ); ?>' ),
								searchFields  : ['title'],
								fullTextSearch: true,
								cache         : true,
								maxResults    : 50
							});
						}
					});
				</script>

			</div>

		<?php } ?>

		<!-- Table -->
		<div class="ui stackable grid wpj-grid-table list-wrapper wpj-dashboard-table">

			<!-- Table header -->
			<div class="row computer tablet only wpj-dashboard-table-header">

				<?php if ( $table_header ) {

					foreach ( $table_header as $label => $column_nr ) { ?>

						<div class="<?php echo $column_nr; ?> wide column table-header-title">

							<div class="table-label"><?php echo $label; ?></div>

						</div>

					<?php }

				} ?>

			</div>

			<!-- Table body -->
			<?php $table_data->show_list_fnc(); ?>

		</div>

	<?php } elseif ( $table_no_results_msg !== '' ) { ?>

		<!-- No results -->
		<div class="ui stackable grid wpj-grid-table list-wrapper wpj-dashboard-table">

			<div class="row computer tablet only wpj-dashboard-table-header">

				<?php if ( $table_header ) {

					foreach ( $table_header as $label => $column_nr ) { ?>

						<div class="<?php echo $column_nr; ?> wide column table-header-title">

							<div class="table-label"><?php echo $label; ?></div>

						</div>

					<?php }

				} ?>

			</div>

			<div class="row">

				<div class="ui stackable grid item-content ">

					<div class="sixteen wide column mv-auto">

						<?php echo $table_no_results_msg; ?>

					</div>

				</div>

			</div>

		</div>
		
	<?php }

} else { ?>

	<!-- Item row -->
	<div class="ui stackable grid item-content <?php echo $table_data; ?>">

		<?php if ( $table_header ) { $indx = 0;

			foreach ( $table_header as $label => $column_nr ) { ?>

				<div class="<?php echo $column_nr; ?> wide column mv-auto">

					<?php if ( $indx > 0 ) { ?>

						<div class="table-label tablet-hidden"><?php echo $label; ?></div>

					<?php } ?>

					<div class="table-value<?php if ( $indx == 0 ) echo ' first-row'; ?>"><?php echo isset( $table_content[$indx] ) ? $table_content[$indx] : ''; ?></div>

				</div>

			<?php $indx++; }

		} ?>

	</div>

<?php }