<?php
/**
 * @var $pid
 * @var $buyer_id
 * @var $seller_id
 * @var $uid
 * @var $seller_name
 * @var $buyer_name
 * @var $title
 */

if ( wpj_is_custom_offer( $pid ) && ! empty( $buyer_id ) && ! empty( $seller_id ) ) { ?>

	<h1 data-pid="<?php echo $pid; ?>">

		<?php echo sprintf( __( "Private transaction with %s", "wpjobster" ), ( $uid == $buyer_id ? $seller_name : $buyer_name ) ); ?>

	</h1>

<?php } else {

	if ( ! empty( $link ) ) { ?>

		<a data-pid="<?php echo $pid; ?>" href="<?php echo $link; ?>">

	<?php }

		if ( ! empty( $icon ) ) { ?>

			<h1 <?php echo ! empty( $title_colour ) ? $title_colour : ''; ?> data-pid="<?php echo $pid; ?>" class="wpj-main-header wpj-title-icon <?php echo ! empty( $title_class ) ? $title_class : ''; ?> <?php echo ! empty( $heading_class ) ? $heading_class : ''; ?>">

				<i <?php echo ! empty( $icon_colour ) ? $icon_colour : ''; ?> class="<?php echo $icon; ?> icon <?php echo ! empty( $icon_class ) ? $icon_class : ''; ?>"></i>

				<?php echo apply_filters( 'wpj_title_filter', trim( $title ) ); ?>

			</h1>

		<?php } else { ?>

			<div data-pid="<?php echo $pid; ?>" class="wpj-main-header <?php echo ! empty( $title_class ) ? $title_class : ''; ?>">

				<h1 class="<?php echo ! empty( $heading_class ) ? $heading_class : ''; ?>" <?php echo ! empty( $title_colour ) ? $title_colour : ''; ?>>

					<?php echo apply_filters( 'wpj_title_filter', trim( $title ) ); ?>

				</h1>

			</div>

		<?php }

	if ( ! empty( $link ) ) { ?>

		</a>

	<?php }

}