<?php
/**
 * @var $placeholder
 * @var $id
 * @var $required
 * @var $disabled
 * @var $class
 * @var $minLength
 * @var $maxLength
 * @var $d_validate
 * @var $pid
 * @var $rejected_description
 * @var $indx
 * @var $action
 * @var $name
 * @var $value
 * @var $toolbar_id
 */
?>

<div class="pr">

	<textarea
		placeholder="<?php echo $placeholder; ?>"
		id="<?php echo $id; ?>"
		rows="6"
		cols="45"
		<?php echo $required ? 'required' : ''; ?>
		<?php echo $disabled ? 'disabled' : ''; ?>
		class="<?php echo $class; ?> wysiwyg-description-textarea <?php echo wpj_get_job_rejected_input( 'description' ); ?>"
		minlength="<?php echo $minLength; ?>"
		maxlength="<?php echo $maxLength; ?>"
		data-validate="<?php echo $d_validate; ?>"
		data-pid="<?php echo $pid; ?>"
		data-post-status="<?php echo $pid ? get_post_status( $pid ) : ''; ?>"
		data-rejected="<?php echo isset( $rejected_description ) ? $rejected_description : ''; ?>"
		data-indx="<?php echo $indx; ?>"
		data-type="<?php echo $action; ?>"
		name="<?php echo $name; ?>"><?php echo $value; ?></textarea>

	<div id="<?php echo $toolbar_id; ?>" class="wysiwyg-description-toolbar">
		<a data-wysihtml5-command="bold"><i class="bordered bold icon"></i></a>
		<a data-wysihtml5-command="italic"><i class="bordered italic icon"></i></a>
		<a data-wysihtml5-command="underline"><i class="bordered underline icon"></i></a>
		<a data-wysihtml5-command="insertUnorderedList"><i class="bordered unordered list icon"></i></a>
		<a data-wysihtml5-command="insertOrderedList"><i class="bordered ordered list icon"></i></a>
	</div>

	<?php if ( $action != 'packages' ) { ?>

		<div class="char-count mt10 fw400"> / <?php echo sprintf( __( '%d Characters', 'wpjobster' ), $maxLength ); ?></div>

	<?php } ?>

</div>