<?php
/**
 * @var $audios
 * @var $audios_details
 */

if ( ! empty( $audios ) && wpj_get_option( 'wpjobster_audio' ) == 'yes' ) { ?>

	<div class="audios-wrapper div-disabled" data-audio-details="<?php echo htmlspecialchars( json_encode( $audios_details ), ENT_QUOTES, 'UTF-8' ); ?>">

		<?php foreach ( $audios as $audio ) { ?>

			<div id="jquery_jplayer_<?php echo $audio->ID; ?>" class="jp-jplayer"></div>

			<div id="jp_container_<?php echo $audio->ID; ?>" class="jp-flat-audio" role="application" aria-label="media player">

				<div class="jp-play-control jp-control">

					<button class="jp-play jp-button" role="button" aria-label="play" tabindex="0"></button>

				</div>

				<div class="jp-bar">

					<div class="jp-seek-bar jp-seek-bar-display"></div>

					<div class="jp-seek-bar">

						<div class="jp-play-bar"></div>

						<div class="jp-details"><span class="jp-title" aria-label="title"></span></div>

						<div class="jp-timing"><span class="jp-duration" role="timer" aria-label="duration"></span></div>

					</div>

				</div>

				<div class="jp-no-solution">

					<?php _e( 'Media Player Error', 'wpjobster' ); ?>

					<br />

					<?php _e( 'Update your browser or Flash plugin', 'wpjobster' ); ?>

				</div>

			</div>

		<?php } ?>

	</div>

<?php } else echo '<style>.job-audio-row-wrapper{display:none;}</style>'; // for page builder