<?php
/**
 * @var $title
 * @var $prc
 * @var $pid
 */
?>

<div class="single-job-sidebar-padded-content">

	<div class="sidebar-top-info">

		<div class="type"><?php echo $title; ?></div>

		<div class="price"><?php echo wpj_show_price( $prc ); ?></div>

	</div>

	<?php wpj_display_title( ['title_class' => 'sidebar-top-title'] ); ?>

	<div class="sidebar-rating">

		<?php wpj_display_job_rating_stars();

		wpj_display_job_reviews_number(); ?>

	</div>

	<div class="sidebar-delivery-location">

		<?php if ( get_post_meta( $pid, 'job_packages', true ) != 'yes' && wpj_get_option( 'wpjobster_enable_delivery_time' ) != 'no' ) { ?>

			<div class="sidebar-delivery-days">

				<img src="<?php echo get_template_directory_uri() . '/assets/images/job/clock-icon.svg'; ?>" alt="<?= __( 'Delivery Days', 'wpjobster' ); ?>" class="icon">

				<?php wpj_display_job_delivery_days_number( $pid ); ?>

			</div>

		<?php }

		wpj_display_job_location( $pid );

		do_action( 'wpj_after_job_sidebar_delivery_location', $pid ); ?>

	</div>

	<?php do_action( 'wpj_before_sidebar_orders_in_queue', $pid ); ?>

	<div class="sidebar-orders-in-queue">

		<?php echo __( 'Orders in queue:', 'wpjobster' ) . '&nbsp;'; wpj_display_job_order_queue_number(); ?>

	</div>

</div>