<?php
/**
 * @var $display_custom_offer
 * @var $pid
 * @var $location
 * @var $page
 */

if ( $display_custom_offer ) {

	wpj_display_custom_offer_button( array(
		'unique_id'       => 'job_request_' . $pid . '_' . $location,
		'id'              => $pid,
		'title'           => __( 'Request Custom Offer', 'wpjobster' ),
		'offer_type'      => 'request',
		'current_user_id' => get_current_user_id(),
		'post_author_id'  => $post->post_author,
		'page'            => $page
	) );

} elseif ( $post->post_author == get_current_user_id() && $location === 'sidebar' ) { ?>

	<div class="mb10">

		<?php
		wpj_display_job_edit_button();
		wpj_display_job_delete_button();
		?>

	</div>

<?php } else echo '<style>.job-edit-or-offer-row-wrapper{display:none;}</style>'; // for page builder