<?php
/**
 * @var $author_vacation
 * @var $author_vacation_reason
 * @var $pid
 * @var $is_post_author
 * @var $button_type
 * @var $submit_class
 * @var $submit_action
 */

if ( $author_vacation ) { ?>

	<span class="text-button text-button-gray disabled"><?php echo $author_vacation_reason; ?></span>

<?php } elseif ( get_post_meta( $pid, "active", true ) != 1 ) { ?>

	<span class="text-button text-button-gray disabled">

		<?php _e( 'Job deactivated', 'wpjobster' ); ?>

	</span>

	<?php if ( $is_post_author ) { ?>

		<a class="activate-job-link js-activate-job-link" data-id="<?php echo $pid; ?>" data-title="<?php echo get_the_title( $pid ); ?>"><?php _e( 'Do you want to activate this job?', 'wpjobster' ); ?></a>

	<?php } ?>

<?php } else { ?>

	<a data-author="<?php echo $post->post_author; ?>" data-pid="<?php echo $pid; ?>" class="text-button job-purchase-action <?php if ( $is_post_author ) echo 'disabled'; ?> <?php echo $button_type; ?> <?php echo $submit_class; ?> js-buy-job-button" <?php echo $submit_action; ?>>

		<?php echo $is_post_author ? __( 'This is your own job', 'wpjobster' ) : _x( 'Continue', 'Buy job button name', 'wpjobster' ); ?>

		<div class="price">&nbsp;(<?php wpj_display_job_order_total_price( 'job_purchase' ); ?>)</div>

	</a>

	<?php if ( $is_post_author ) { ?>

		<a class="deactivate-job-link js-deactivate-job-link cursor-pointer" data-id="<?php echo $pid; ?>" data-title="<?php echo get_the_title( $pid ); ?>"><?php _e( 'Do you want to deactivate this job?', 'wpjobster' ); ?></a>

	<?php }

}