<?php
/**
 * @var $ret_element
 * @var $payment_type
 * @var $display_fast_delivery
 * @var $display_location
 * @var $allow_extra
 * @var $pid
 * @var $fast_delivery_amount_max
 * @var $display_additional_revision
 * @var $add_rev_amount_max
 * @var $extra_job_add
 * @var $extra_amount_max
 * @var $shipping
 * @var $buyer_processing_fees
 * @var $tax_amount
 */

if ( ! $ret_element ) { ?>

	<div class="ui list job-order-info">

<?php }

		// Extra Fast Delivery
		if ( ( ! $ret_element || $ret_element == 'extra_fast_delivery' ) && $payment_type == 'job_purchase' && $display_fast_delivery ) {

			if ( $display_location != 'sidebar' ) { ?><div class="ui divider"></div><?php } ?>

			<div class="<?php if ( $display_location == 'sidebar' ) echo 'single-job-sidebar-price-content'; ?> extra_nb_fast">

				<div class="item extra-item" data-extranr="fast" data-extraamount="<?php echo WPJ_Form::post( 'hid_extrafast', 1 ); ?>">

					<div class="ui <?php echo WPJ_Form::post( 'extrafast' ) ? 'checked' : ''; ?> checkbox <?php if ( ! $allow_extra ) echo 'disabled'; ?>">

						<input
							type="checkbox"
							name="extrafast"
							class="uzextracheck chk_extrafast"
							value="1"
							data-price="<?php echo wpj_number_format_special_exchange( get_post_meta( $pid, 'extra_fast_price', true ) ); ?>"
							<?php if ( ! $allow_extra ) echo 'disabled'; ?>
							<?php if ( WPJ_Form::post( 'extrafast' ) ) echo 'checked'; ?>
						/>

						<label>

							<?php _e( 'Extra fast delivery', 'wpjobster' );

							if ( wpj_get_option( 'wpjobster_enable_delivery_time' ) != 'no' ) { ?>

								<span>

									<?php echo sprintf( _n( '(%d day)', '(%d days)', get_post_meta( $pid, 'extra_fast_days', true ), 'wpjobster' ), get_post_meta( $pid, 'extra_fast_days', true ) ); ?>

								</span>

							<?php } ?>

						</label>

					</div>

					<div class="price-content">

						<span class="extra-price-inside">

							<?php echo wpj_show_price( get_post_meta( $pid, 'extra_fast_price', true ) ); ?>

						</span>

						<?php if ( $fast_delivery_amount_max > 1 ) { ?>

							<span class="amount_section" data-amountnb="fast">

								<?php if ( $allow_extra ) { ?><a class="cursor-pointer amount_rmv">&minus;</a><?php } ?>

								<input
									type="text"
									name="hid_extrafast"
									class="current_amount hid_extrafast"
									value="<?php echo WPJ_Form::post( 'hid_extrafast', 1 ); ?>"
									data-max="<?php echo $fast_delivery_amount_max; ?>"
									<?php if ( ! $allow_extra ) echo 'disabled'; ?>
								/>

								<?php if ( $allow_extra ) { ?><a class="cursor-pointer amount_add">&plus;</a><?php } ?>

							</span>

						<?php } ?>

					</div>

				</div>

			</div>

		<?php }

		// Additional Revision
		if ( ( ! $ret_element || $ret_element == 'additional_revision' ) && $payment_type == 'job_purchase' && $display_additional_revision ) {

			if ( $display_location != 'sidebar' ) { ?><div class="ui divider"></div><?php } ?>

			<div class="<?php if ( $display_location == 'sidebar' ) echo 'single-job-sidebar-price-content'; ?> extra_nb_revision">

				<div class="item extra-item" data-extranr="revision" data-extraamount="<?php echo WPJ_Form::post( 'hid_extrarevision', 1 ); ?>">

					<div class="ui <?php echo WPJ_Form::post( 'extrarevision' ) ? 'checked' : ''; ?> checkbox <?php if ( ! $allow_extra ) echo 'disabled'; ?>">

						<input
							type="checkbox"
							name="extrarevision"
							class="uzextracheck chk_extrarevision"
							value="1"
							data-price="<?php echo wpj_number_format_special_exchange( get_post_meta( $pid, 'extra_revision_price', true ) ); ?>"
							<?php if ( ! $allow_extra ) echo 'disabled'; ?>
							<?php if ( WPJ_Form::post( 'extrarevision' ) ) echo 'checked="checked"'; ?>
						/>

						<label>

							<?php _e( 'Extra revision', 'wpjobster' );

							if ( wpj_get_option( 'wpjobster_enable_delivery_time' ) != 'no' ) { ?>

								<span>

									<?php echo sprintf( _n( '(+%d day)', '(+%d days)', get_post_meta( $pid, 'extra_revision_days', true ), 'wpjobster' ), get_post_meta( $pid, 'extra_revision_days', true ) ); ?>

								</span>

							<?php } ?>

						</label>

					</div>

					<div class="price-content">

						<span class="extra-price-inside">

							<?php echo wpj_show_price( get_post_meta( $pid, 'extra_revision_price', true ) ); ?>

						</span>

						<?php if ( $add_rev_amount_max > 1 && get_post_meta( $pid, 'extra_revision_multiples_enabled', true ) ) { ?>

							<span class="amount_section" data-amountnb="revision">

							<?php if ( $allow_extra ) { ?><a class="cursor-pointer amount_rmv">&minus;</a><?php } ?>

							<input
								type="text"
								name="hid_extrarevision"
								class="current_amount hid_extrarevision"
								value="<?php echo WPJ_Form::post( 'hid_extrarevision', 1 ); ?>"
								data-max="<?php echo $add_rev_amount_max; ?>"
								<?php if ( ! $allow_extra ) echo 'disabled'; ?>
							/>

							<?php if ( $allow_extra ) { ?><a class="cursor-pointer amount_add">&plus;</a><?php } ?>

						</span>

						<?php } ?>

					</div>

				</div>

			</div>

		<?php }

		// Extra
		if ( ( ! $ret_element || $ret_element == 'extras' ) && $payment_type == 'job_purchase' && $extra_job_add ) { $i = 0;
			foreach ( $extra_job_add as $extra_job_add_item ) { $i++;

				$enabled = get_post_meta( $pid, 'extra' . $i . '_extra_enabled', false );

				if ( isset( $enabled[0] ) ) {
					$enabled = $enabled[0];

				} else {
					$enabled = 1; update_post_meta( $pid, 'extra' . $i . '_extra_enabled', true );

				}

				if ( $enabled && ( $allow_extra || WPJ_Form::post( 'extra' . $i ) ) ) {

					if ( $display_location != 'sidebar' ) { ?><div class="ui divider"></div><?php } ?>

					<div class="<?php if ( $display_location == 'sidebar' ) echo 'single-job-sidebar-price-content'; ?> extra_nb_<?php echo $extra_job_add_item['extra_nr']; ?>">

						<div class="item extra-item" data-extranr="<?php echo $i; ?>" data-extraamount="<?php echo WPJ_Form::post( 'hid_extra' . $i, 1 ); ?>">

							<div class="ui <?php echo WPJ_Form::post( 'extra' . $i ) ? 'checked' : ''; ?> checkbox <?php if ( ! $allow_extra ) echo 'disabled'; ?>">

								<input
									type="checkbox"
									name="extra<?php echo $extra_job_add_item['extra_nr']; ?>"
									class="uzextracheck chk_extra<?php echo $extra_job_add_item['extra_nr']; ?>"
									value="1"
									data-price="<?php echo wpj_number_format_special_exchange( $extra_job_add_item['price'] ); ?>"
									<?php if ( ! $allow_extra ) echo 'disabled'; ?>
									<?php if ( WPJ_Form::post( 'extra' . $i ) ) echo 'checked="checked"'; ?>
								/>

								<label>

									<?php echo wpj_apply_filter_to_string( $extra_job_add_item['content'], false, 'joblistings' );

									if ( wpj_get_option( 'wpjobster_enable_delivery_time' ) != 'no' ) { ?>

										<span>

											<?php echo sprintf( _n( '(+%d day)', '(+%d days)', get_post_meta( $pid, 'max_days_ex_' . $i, true ), 'wpjobster' ), get_post_meta( $pid, 'max_days_ex_' . $i, true ) ); ?>

										</span>

									<?php } ?>

								</label>

							</div>

							<div class="price-content">

								<span class="extra-price-inside"><?php echo wpj_show_price( $extra_job_add_item['price'] ); ?></span>

								<?php if ( $extra_job_add_item['enabled'] && $extra_amount_max > 1 ) { ?>

									<span class="amount_section" data-amountnb="<?php echo $extra_job_add_item['extra_nr']; ?>">

									<?php if ( $allow_extra ) { ?><a class="cursor-pointer amount_rmv">&minus;</a><?php } ?>

									<input
										type="text"
										name="hid_extra<?php echo $extra_job_add_item['extra_nr']; ?>"
										class="current_amount hid_extra<?php echo $extra_job_add_item['extra_nr']; ?>"
										value="<?php echo WPJ_Form::post( 'hid_extra' . $i, 1 ); ?>"
										data-amountnb="<?php echo $extra_job_add_item['extra_nr']; ?>"
										data-max="<?php echo $extra_amount_max; ?>"
										<?php if ( ! $allow_extra ) echo 'disabled'; ?>
									/>

									<?php if ( $allow_extra ) { ?><a class="cursor-pointer amount_add">&plus;</a><?php } ?>

								</span>

								<?php } ?>

							</div>

						</div>

						<?php do_action( 'wpj_after_admin_extra_display', $pid, $i ); ?>

					</div>

				<?php }
			}
		}

		do_action( 'wpj_before_shipping_price', $pid, $display_location );

		// Shipping
		if ( ( ! $ret_element || $ret_element == 'shipping' ) && $payment_type == 'job_purchase' && $shipping && wpj_get_option( 'wpjobster_enable_shipping' ) != 'no' ) {

			if ( $display_location != 'sidebar' ) { ?><div class="ui divider"></div><?php } ?>

			<div class="<?php if ( $display_location == 'sidebar' ) echo 'single-job-sidebar-price-content'; ?> js-shipping shipping-cost">

				<div class="item">

					<div class="price-label">

						<?php _e( "Shipping", 'wpjobster' ); ?>

					</div>

					<div class="price-value">

						<?php if ( $display_location != 'sidebar' ) { ?><span class="extra-price-inside"><?php }

							echo wpj_show_price( $shipping );

						if ( $display_location != 'sidebar' ) { ?></span><?php } ?>

					</div>

				</div>

			</div>

		<?php }

		// Processing fees
		if ( ( ! $ret_element || $ret_element == 'processing_fees' ) && wpj_get_option( 'wpjobster_enable_buyer_processing_fees' ) != 'disabled' ) {

			if ( $display_location != 'sidebar' && $buyer_processing_fees && ! $shipping ) { ?><div class="ui divider"></div><?php }

			if ( $buyer_processing_fees || get_post_meta( $pid, 'job_packages', true ) == 'yes' ) { ?>

				<div class="<?php if ( $display_location == 'sidebar' ) echo 'single-job-sidebar-price-content'; ?> js-processingfees mt10">

					<div class="item">

						<div class="price-label">

							<?php if ( wpj_get_option( 'wpjobster_enable_buyer_processing_fees' ) == 'percent' )
								echo sprintf( __( 'Processing Fees (%s%s)', 'wpjobster' ), wpj_get_option( 'wpjobster_buyer_processing_fees_percent' ), '&#37;' );

							else
								_e( 'Processing Fees', 'wpjobster' ); ?>

						</div>

						<div class="processingfee-amount price-value">

							<?php if ( $display_location != 'sidebar' ) { ?><span class="extra-price-inside"><?php }

								echo wpj_show_price( $buyer_processing_fees );

							if ( $display_location != 'sidebar' ) { ?></span><?php } ?>

						</div>

					</div>

				</div>

			<?php }

		}

		if ( ! $ret_element || $ret_element == 'tax' ) do_action( 'wpj_before_tax_price', $pid, $display_location );

		// Tax
		if ( ( ! $ret_element || $ret_element == 'tax' ) && wpj_get_option( 'wpjobster_enable_site_tax' ) != 'no' ) {

			if ( $display_location != 'sidebar' && $tax_amount && ! $shipping && ! $buyer_processing_fees ) { ?><div class="ui divider"></div><?php }

			if ( $tax_amount || get_post_meta( $pid, 'job_packages', true ) == 'yes' ) { ?>

				<div class="<?php if ( $display_location == 'sidebar' ) echo 'single-job-sidebar-price-content'; ?> js-processingtax mt10">

					<div class="item">

						<div class="price-label">

							<?php echo sprintf( __( 'Tax (%s%s)', 'wpjobster' ), wpj_get_site_tax_percent(), '&#37;' ); ?>

						</div>

						<div class="tax-amount price-value">

							<?php if ( $display_location != 'sidebar' ) { ?><span class="extra-price-inside"><?php }

								echo wpj_show_price( $tax_amount );

							if ( $display_location != 'sidebar' ) { ?></span><?php } ?>

						</div>

					</div>

				</div>

			<?php }

		}

		if ( ! $ret_element || $ret_element == 'tax' ) do_action( 'wpj_after_tax_price', $pid, $display_location );

if ( ! $ret_element ) { ?>

	</div>

<?php }