<?php
/**
 * @var $display_location
 * @var $with_label
 */

if ( $display_location == 'sidebar' ) { ?>

	<div class="order-additional-sidebar-wrapper">

		<div class="order-additional-wrapper order-additional-form-wrapper">

			<?php if ( get_post_meta( $pid, 'price_type', true ) != 'custom' ) wpj_display_job_order_details_form( $pid, $display_location );

			if ( get_post_meta( $pid, 'price_type', true ) == 'custom' ) { ?><div class="separator-15px"></div><?php }

			// Request Custom Offer Button
			wpj_display_job_or_offer_button( $pid, 'single_job', $display_location ); ?>

			<div class="job-sidebar-after-form">

				<?php do_action( 'wpj_after_single_job_sidebar_form_content', $pid, get_the_title( $pid ) ); ?>

			</div>

		</div>

	</div>

<?php } else { ?>

	<div class="order-additional-wrapper">

		<?php if ( $with_label ) { ?>

			<div class="single-job-additional-title">

				<h2><?php _e( "Order Additional", "wpjobster" ); ?></h2>

			</div>

		<?php }

		// Payment Form
		if ( get_post_meta( $pid, 'price_type', true ) != 'custom' ) wpj_display_job_order_details_form( $pid, $display_location );
		elseif ( get_post_meta( $pid, 'price_type', true ) == 'custom' && get_current_user_id() == get_post_field( 'post_author', $pid ) )
			echo '<style>.job-order-additional-row-wrapper{display:none;}</style>'; // for page builder

		if ( $display_location != 'checkout' ) { ?>

			<div class="ui divider"></div>

			<?php // Buy Button
			if ( get_post_meta( $pid, 'price_type', true ) != 'custom' ) wpj_display_job_order_button( 'small', $pid );

			// Request Custom Offer Button
			wpj_display_job_or_offer_button( $pid, 'single_job', $display_location );

		} ?>

	</div>

<?php }