<?php
/**
 * @var $decimal_sum_separator
 * @var $thousands_sum_separator
 * @var $prc
 * @var $shipping
 * @var $payment_type
 */
?>

<span id="showtotal" class="total"
	data-cur                   = "<?php echo wpj_get_site_currency(); ?>"
	data-symbol                = "<?php echo wpj_get_currency_symbol_by_name( wpj_get_site_currency() ); ?>"
	data-position              = "<?php echo wpj_get_option( 'wpjobster_currency_position' ); ?>"
	data-space                 = "<?php echo wpj_get_option( 'wpjobster_currency_symbol_space' ); ?>"
	data-decimal               = "<?php echo $decimal_sum_separator; ?>"
	data-thousands             = "<?php echo $thousands_sum_separator; ?>"
	data-decimaldisplay        = "<?php echo wpj_get_option( 'wpjobster_decimals' ); ?>"
	data-price                 = "<?php echo wpj_number_format_special_exchange( $prc ); ?>"
	data-shipping              = "<?php echo wpj_number_format_special_exchange( $shipping ); ?>"
	data-processingfeesenable  = "<?php echo wpj_get_option( 'wpjobster_enable_buyer_processing_fees' ); ?>"
	data-processingfeesfixed   = "<?php echo wpj_number_format_special_exchange( wpj_get_option( 'wpjobster_buyer_processing_fees' ) ); ?>"
	data-processingfeespercent = "<?php echo wpj_get_option( 'wpjobster_buyer_processing_fees_percent' ); ?>"
	data-taxover               = "<?php echo wpj_get_option( 'wpjobster_tax_over' ); ?>"
	data-tax                   = "<?php echo wpj_get_site_tax_percent(); ?>"
	data-zerowithfree          = "<?php echo wpj_get_option( 'wpjobster_replace_zero_with_free' ); ?>"
	data-freestr               = "<?php _e( "Free", "wpjobster" ); ?>"
>

	<?php if ( $payment_type == 'job_purchase' || $payment_type == 'custom_extra' || $payment_type == 'tips' ) {

		if ( $prc > 0 ) echo wpj_show_price( $prc );
		else {
			if ( wpj_bool_option( 'wpjobster_replace_zero_with_free' ) ) { _e( 'Free','wpjobster' ); }
			else { echo wpj_show_price( $prc ); }
		}

	} else echo wpj_show_price( 0 ); ?>

</span>