<?php
/**
 * @var $wrapper_class
 * @var $display_location
 * @var $is_price_type
 * @var $quantity
 * @var $job_amount_max
 * @var $price_type
 * @var $pid
 * @var $package_nr
 * @var $allow_extra
 */
?>

<div class="main-amount-box <?php echo $wrapper_class; ?> js-job-quantity-wrapper">

	<?php if ( $display_location == 'order_additional' ) { ?><div class="ui divider"></div><?php } ?>

	<div class="item payment-main-item" data-mainamount="<?php echo WPJ_Form::post( 'main_value_inp', 1 ); ?>">

		<div class="rate-type price-label">

			<?php if ( $is_price_type && ( $quantity == 'yes' && $job_amount_max > 1 ) ) { ?>

				<span class="description job-quantity">

					<?php echo sprintf( __( '%s Rate/Number of %s', 'wpjobster' ), wpj_translate_string( $price_type ), wpj_translate_string( wpj_change_rate_word( $price_type, 'plural' ) ) ); ?>

					<!-- Keep this space for layout when ! $is_price_type -->
					&nbsp;

				</span>

			<?php } elseif ( $is_price_type ) {

				echo apply_filters( 'wpj_price_type_filter', sprintf( __( '%s Rate', 'wpjobster' ), wpj_translate_string( $price_type ) ), $pid );

			} else _e( 'Job Quantity', 'wpjobster' ); ?>

		</div>

		<div class="price-content price-value">

			<span class="extra-price-inside">

				<?php wpj_display_job_order_price( $pid, 'fw400 fs14', false, $package_nr ); ?>

			</span>

			<?php if ( $is_price_type || ( $quantity == 'yes' && $job_amount_max > 1 ) ) {

				if ( $quantity == 'yes' && $job_amount_max > 1 ) { ?>

					<span class="amount_section">

						<?php if ( $allow_extra ) { ?><a class="cursor-pointer amount_rmv">&minus;</a><?php } ?>

						<input
							type="text"
							name="main_value_inp"
							class="main_value_inp current_amount main_amount"
							value="<?php echo WPJ_Form::post( 'main_value_inp', 1 ); ?>"
							data-max="<?php echo $job_amount_max; ?>"
							<?php if ( ! $allow_extra ) echo 'disabled'; ?>
						/>

						<?php if ( $allow_extra ) { ?><a class="cursor-pointer amount_add">&plus;</a><?php } ?>

					</span>

				<?php }

			} ?>

		</div>

	</div>

</div>