<?php
/**
 * @var $languages_arr
 * @var $current_language
 */
?>

<li class="nh-accordion-container">

	<a class="item nh-accordion-handler"><?php _e( "Language", "wpjobster" ); ?></a>

	<div class="nh-accordion" style="display: none;">

		<ul class="reset">

			<?php foreach ( $languages_arr as $language ) {

				$code = $language['code'];
				if ( $language['code'] == 'en' ) $code = 'us';
				if ( $language['code'] == 'ar' ) $code = 'ae'; ?>

				<li>

					<a href="<?php echo $language['url']; ?>" class="item <?php echo $language == $current_language ? 'active selected' : ''; ?>" title="<?php echo $language['name']; ?>">

						<i class="<?php echo $code; ?> flag"></i>

						<?php echo $language['name']; ?>

					</a>

				</li>

			<?php } ?>

		</ul>

	</div>

</li>