<?php
/**
 * @var $title
 * @var $title_label
 * @var $attachments
 * @var $meta_name
 * @var $file_size
 * @var $delete_action
 * @var $pid
 */
?>

<div class="attachments-wrapper">

	<?php if ( $title ) { ?>

		<div class="attachment-title"><?php echo $title_label; ?></div>

	<?php }

	if ( $attachments ) {

		foreach ( $attachments as $attachment ) {

			if ( get_attached_file( $attachment ) != "" ) {

				if ( $meta_name == 'image_attachments' ) { ?>

					<a href="<?php echo wpj_get_attachment_image_url( $attachment, 'full' ); ?>" class="js-pm-image-attachments-gallery">

						<img src="<?php echo wpj_get_attachment_image_url( $attachment, 'square_150' ); ?>" alt="">

					</a>

				<?php } else { ?>

					<div class="attachment-item-wrapper file-wrapper" id="<?php echo $attachment; ?>">

						<div class="attachment-item-content">

							<img src="<?php echo get_template_directory_uri() . '/assets/images/media/download-file.svg'; ?>" alt="">

							<a class="attachment-item-link" target="_blank" href="<?php echo get_bloginfo( 'url' ) . '/?secure_download=' . $attachment . wpj_get_token(); ?>" download>

								<?php echo substr( get_the_title( $attachment ), 0, 20 ) . '...';

								if ( $file_size ) { ?>

									<span class="attachment-item-filesize">( <?php echo size_format( filesize( get_attached_file( $attachment ) ) ); ?> )</span>

								<?php } ?>

							</a>

							<?php if ( $delete_action ) { ?>

								<a data-attachment-id="<?php echo $attachment; ?>" data-pid="<?php echo $pid; ?>" data-media-type="<?php echo $meta_name; ?>" class="js-delete-file delete-file delete-attachment cursor-pointer"></a>

							<?php } ?>

						</div>

					</div>

				<?php }

			}

		}

	} ?>

</div>