<?php
/**
 * @var $pid
 * @var $width
 * @var $oid
 * @var $height
 * @var $link
 * @var $no_image_src
 */

if ( wpj_is_custom_offer( $pid ) ) { ?>

	<style type="text/css">
		.custom-offer-avatar {
			width: <?php echo $width; ?>px;
			background: url(<?php echo wpj_get_avatar( wpj_get_buyer_id( $oid ) ?: get_current_user_id(), $width, $height ); ?>) center/cover;
		}
		.custom-offer-avatar::after {
			background: url(<?php echo wpj_get_avatar( get_post_field( 'post_author', $pid ), $width, $height ); ?>) center/cover;
		}
	</style>

	<div class="no-border round-avatar custom-offer-avatar"></div>

<?php } elseif ( wpj_get_job_image( $pid, $width, $height ) ) { ?>

	<a href="<?php echo $link; ?>">

		<img width="<?php echo $width; ?>" height="<?php echo $height; ?>" class="round-avatar" src="<?php echo wpj_get_job_image( $pid, $width, $height ); ?>" alt="" />

	</a>

<?php } else { ?>

	<img alt="no avatar" class="no-border round-avatar" src="<?php echo $no_image_src; ?>" width="<?php echo $width; ?>" height="<?php echo $height; ?>" />

<?php }