<?php
/**
 * @var $menu
 * @var $items_no
 * @var $split_menu
 * @var $language
 * @var $currency
 * @var $logout
 */
?>

<ul class="reset">

	<?php if ( $menu && is_array( $menu ) ) { $i = 0;

		foreach ( $menu as $menu_item ) { $i++; ?>

			<li class="<?php if ( ! empty( $menu_item['childs'] ) ) { echo 'nh-accordion-container'; } if ( ! empty( $menu_item['classes'] ) ) { echo ' ' . $menu_item['classes']; } ?>">

				<a class="item<?php if ( isset( $menu_item['childs'] ) && $menu_item['childs'] ) { echo ' nh-accordion-handler'; } ?>" href="<?php if ( isset( $menu_item['url'] ) && is_numeric( $menu_item['url'] ) ) { echo get_permalink( $menu_item['url'] ); } else { echo isset( $menu_item['url'] ) ? $menu_item['url'] : ''; } ?>"><?php echo isset( $menu_item['label'] ) ? $menu_item['label'] : ''; ?></a>

				<?php if ( ! function_exists( 'wpj_render_dropdown_menu_items' ) ) {
					function wpj_render_dropdown_menu_items( $menu_item ) {
						if ( isset( $menu_item['childs'] ) && $menu_item['childs'] ) {
							$childs = wpj_sort_menu( $menu_item['childs'], 'DESC' ); ?>

							<div class="nh-accordion" style="display: none;">
								<ul class="reset">

									<?php foreach ( $childs as $child ) {
										$li_classes = [];

										if ( ! empty( $child['childs'] ) ) {
											$li_classes[] = 'nh-accordion-container';
										}

										if ( ! empty( $child['classes'] ) ) {
											$li_classes[] = $child['classes'];
										}

										$child_url = ! empty( $child['url'] ) ? $child['url'] : '';

										if ( isset( $child['url'] ) && is_numeric( $child['url'] ) ) {
											$child_url = get_permalink( $child['url'] );
										}

										echo sprintf(
											'<li class="%s"><a class="item%s" href="%s">%s</a>',
											implode( ' ', $li_classes ),
											! empty( $child['childs'] ) ? ' nh-accordion-handler' : '',
											esc_url( $child_url ),
											! empty( $child['label'] ) ? esc_html( $child['label'] ) : ''
										);

											wpj_render_dropdown_menu_items( $child );

										echo '</li>';
									} ?>

								</ul>
							</div>

						<?php }
					}
				}

				wpj_render_dropdown_menu_items( $menu_item ); ?>

			</li>

			<?php if ( $i == ceil ( $items_no / 2 ) && $split_menu ) { ?>

</ul><ul class="reset">

			<?php }

		}
	}

	// Language selector
	if ( $language ) wpj_display_languages_selector( 'mobile' );

	// Currency selector
	if ( $currency ) wpj_display_currency_selector( 'mobile' );

	if ( $logout ) { ?>

		<li class="log-out-list-item">

			<a class="item log-out color-ff6c61" href="<?php echo wp_logout_url( get_site_URL() ); ?>"><?php _e( 'Log out', 'wpjobster' ); ?></a>

		</li>

	<?php } ?>

</ul>