<?php
/**
 * @var $user_badge
 * @var $badges_data
 */

if ( wpj_get_option( 'wpjobster_enable_badges_sale' ) != 'yes' ) {

	wpj_display_message( array(
		'message_class'   => 'info',
		'is_hidden'       => false,
		'message_header'  => __( 'Badges are disabled!', 'wpjobster' ),
		'message_content' => __( 'Badges are not available at this time. Please contact the administrator of this site for help.', 'wpjobster' )
	) );

	echo '<style>.badge-payment-buttons-row-wrapper{display:none;}</style>'; // for page builder

} elseif ( ! apply_filters( 'hide_for_buyers', true, get_current_user_id() ) ) {

	wpj_display_message( array(
		'message_class'   => 'info',
		'is_hidden'       => false,
		'message_header'  => __( 'Access denied!', 'wpjobster' ),
		'message_content' => __( 'You must be a seller to access this page.', 'wpjobster' )
	) );

	echo '<style>.badge-payment-buttons-row-wrapper{display:none;}</style>'; // for page builder

} elseif ( wpj_get_option( 'wpjobster_credits_enable' ) == 'no' ) {

	wpj_display_message( array(
		'message_class'   => 'info',
		'is_hidden'       => false,
		'message_header'  => __( 'Credits are disabled!', 'wpjobster' ),
		'message_content' => __( 'Credits are not available at this time. Please contact the administrator of this site for help.', 'wpjobster' )
	) );

	echo '<style>.badge-payment-buttons-row-wrapper{display:none;}</style>'; // for page builder

} elseif ( is_array( $user_badge ) && is_array( $badges_data ) && count( $user_badge ) >= count( $badges_data['redux_repeater_data'] ) ) {

	wpj_display_message( array(
		'message_class'   => 'info',
		'is_hidden'       => false,
		'message_header'  => __( 'You have already bought all the badges.', 'wpjobster' ),
		'message_content' => __( 'You can no longer purchase badges, as all badges that have been added so far are already purchased.', 'wpjobster' )
	) );

	echo '<style>.badge-payment-buttons-row-wrapper{display:none;}</style>'; // for page builder

}