<?php
/**
 * @var $pid
 * @var $status_class
 * @var $status_message
 */

if ( wpj_get_option( 'wpjobster_featured_enable' ) == 'no' || ! wpj_featured_category_enabled_exist() ) {

	wpj_display_message( array(
		'message_class'   => 'info',
		'is_hidden'       => false,
		'message_header'  => __( 'Features are disabled!', 'wpjobster' ),
		'message_content' => __( 'Features are not available at this time. Please contact the administrator of this site for help.', 'wpjobster' )
	) );

	echo '
		<style>
			.featured-list-row-wrapper,
			.featured-processing-fees-row-wrapper,
			.featured-processing-fees-spacer,
			.featured-tax-row-wrapper,
			.featured-payment-buttons-row-wrapper {
				display:none;
			}
		</style>
	'; // for page builder

} elseif ( ! wpj_is_featured_available( $pid ) ) {

	wpj_display_message( array(
		'message_class'   => 'info',
		'is_hidden'       => false,
		'message_header'  => __( 'No available featured spots!', 'wpjobster' ),
		'message_content' => __( 'There are no available featured spots for this job at the moment.', 'wpjobster' )
	) );

	echo '
		<style>
			.featured-processing-fees-row-wrapper,
			.featured-processing-fees-spacer,
			.featured-tax-row-wrapper,
			.featured-payment-buttons-row-wrapper {
				display:none;
			}
		</style>
	'; // for page builder

} elseif ( $status_class && $status_message ) { ?>

	<div class="ui <?php echo $status_class; ?> message">

		<?php echo $status_message;

		if ( $status_class == 'negative' ) {
			do_action( 'wpj_after_gateway_transaction_cancelled_message', $pid, 'feature' );
		} ?>

	</div>

<?php }

if ( wpj_get_option( 'wpjobster_enable_buyer_processing_fees' ) == 'disabled' )
	echo '<style>.featured-processing-fees-row-wrapper, .featured-processing-fees-spacer { display:none; }</style>'; // for page builder

if ( wpj_get_option( 'wpjobster_enable_site_tax' ) != 'yes' )
	echo '<style>.featured-tax-row-wrapper { display:none; }</style>'; // for page builder

if (
	wpj_get_option( 'wpjobster_enable_buyer_processing_fees' ) != 'disabled'
	&& wpj_get_option( 'wpjobster_enable_site_tax' ) != 'yes'
) {
	echo '<style>.featured-processing-fees-row-wrapper { margin-bottom: 20px; }</style>'; // for page builder
}