<?php
/**
 * @var $uid
 * @var $JobsNewEditClass
 */

if ( isset( $_POST['aoe_form_submitted'] ) && ( ! isset( $_POST['post_new_or_edit_job_field'] ) || ! wp_verify_nonce( $_POST['post_new_or_edit_job_field'], 'post_new_or_edit_job_action' ) ) ) {

	wpj_display_message( array(
		'message_class'     => 'negative mt20',
		'is_hidden'         => false,
		'with_close_icon'   => false,
		'icon_class'        => false,
		'message_content'   => __( 'Sorry, your nonce did not verify.', 'wpjobster' ),
		'content_paragraph' => false
	) );

} elseif ( wpj_get_user_feature_status( 'wpjobster_enable_active_jobs', 'wpjobster_subscription_active_jobs_enabled' ) == 'yes'
	&& intval( wpj_get_user_jobs_count( get_current_user_id(), 'active' ) ) >= wpj_get_user_feature_value( 'active_jobs', 'active_jobs' )
	&& ! WPJ_Form::get( 'action' )
) {

	wpj_display_message( array(
		'message_class'     => 'negative mt20',
		'is_hidden'         => false,
		'with_close_icon'   => false,
		'icon_class'        => false,
		'message_content'   => sprintf( __( 'You are not allowed to post a new job because you have reached the maximum number of jobs (%d) you are allowed to post.', 'wpjobster' ), wpj_get_user_feature_value( 'active_jobs', 'active_jobs' ) ),
		'content_paragraph' => false
	) );

	echo '<style>.post-new-job-tab-content-row-wrapper, .post-new-job-instructions-row-wrapper, .post-new-job-tab-navigation-row-wrapper{display:none;}</style>'; // for page builder

} elseif ( WPJ_Form::get( 'action' ) == 'edit-job' && $uid != $post->post_author ) {

	wpj_display_message( array(
		'message_class'     => 'negative mt20',
		'is_hidden'         => false,
		'with_close_icon'   => false,
		'icon_class'        => false,
		'message_content'   => __( 'You are not allowed to edit this job because you are not the author.', 'wpjobster' ),
		'content_paragraph' => false
	) );

	echo '<style>.post-new-job-tab-content-row-wrapper, .post-new-job-instructions-row-wrapper, .post-new-job-tab-navigation-row-wrapper{display:none;}</style>'; // for page builder

} elseif ( isset( $_POST['aoe_form_submitted'] ) && ! $JobsNewEditClass->validatePostData() ) {

	wpj_display_message( array(
		'message_class'     => 'negative mt20',
		'is_hidden'         => false,
		'with_close_icon'   => false,
		'icon_class'        => false,
		'message_content'   => __( 'Complete all required fields.', 'wpjobster' ),
		'content_paragraph' => false
	) );

} else echo '<style>.post-new-job-notices-row-wrapper{display:none;}</style>'; // for page builder

if ( ! current_user_can( 'manage_options' ) ) echo '<style>.post-new-job-instructions-row-wrapper{display:none;}</style>'; // for page builder

if ( WPJ_Form::get( 'action' ) == 'edit-job' ) echo '<style>.new-job-title-wrapper{display:none;}</style>'; // for page builder
else echo '<style>.edit-job-title-wrapper{display:none;}</style>'; // for page builder