<?php
/**
 * @var $uid
 * @var $post
 * @var $RequestsNewEditClass
 */

if ( isset( $_POST['aoer_form_submitted'] ) && ( ! isset( $_POST['post_new_or_edit_request_field'] ) || ! wp_verify_nonce( $_POST['post_new_or_edit_request_field'], 'post_new_or_edit_request_action' ) ) ) {

	wpj_display_message( array(
		'message_class'     => 'negative mt20',
		'is_hidden'         => false,
		'message_content'   => __( 'Sorry, your nonce did not verify.', 'wpjobster' ),
		'content_paragraph' => false
	) );

} elseif ( WPJ_Form::get( 'action' ) == 'edit-request' && $uid != $post->post_author ) {

	wpj_display_message( array(
		'message_class'     => 'negative mt20',
		'is_hidden'         => false,
		'message_content'   => __( 'You are not allowed to edit this request because you are not the author.', 'wpjobster' ),
		'content_paragraph' => false,
		'with_close_icon'   => false,
		'icon_class'        => false
	) );

	echo '<style>.post-new-request-form-row-wrapper{display:none;}</style>'; // for page builder

} elseif ( isset( $_POST['aoer_form_submitted'] ) && ! $RequestsNewEditClass->validatePostData() ) {

	wpj_display_message( array(
		'message_class'     => 'negative mt20',
		'is_hidden'         => false,
		'message_content'   => __( 'Complete all required fields.', 'wpjobster' ),
		'content_paragraph' => false
	) );

} else echo '<style>.post-new-request-notices-row-wrapper{display:none;}</style>'; // for page builder

if ( ! current_user_can( 'manage_options' ) ) echo '<style>.post-new-request-instructions-row-wrapper{display:none;}</style>'; // for page builder

if ( WPJ_Form::get( 'action' ) == 'edit-request' ) echo '<style>.new-request-title-wrapper{display:none;}</style>'; // for page builder
else echo '<style>.edit-request-title-wrapper{display:none;}</style>'; // for page builder