<?php
/**
 * @var $message_type
 * @var $message
 * @var $current_subscription
 */

if ( wpj_get_option( 'wpjobster_subscription_enabled' ) == 'yes' ) {

	if ( $message_type && $message ) {
		wpj_display_message( array(
			'message_class'     => $message_type,
			'is_hidden'         => false,
			'message_content'   => $message,
			'content_paragraph' => false,
		) );

	}

	if ( is_object( $current_subscription ) ) {
		$message_content = sprintf( __( 'You are currently subscribed to %1$s with a %2$s billing period.', 'wpjobster' ), wpj_translate_string( $current_subscription->subscription_level ), wpj_translate_string( $current_subscription->subscription_type ) );

		if ( $current_subscription->subscription_type != 'lifetime' )
			$message_content .= sprintf( __( '&nbsp;Your next biling due date is %s.', 'wpjobster' ), $current_subscription->next_billing_date );

		wpj_display_message( array(
			'message_class'   => 'info',
			'is_hidden'       => false,
			'message_content' => $message_content
		) );

		echo '<style>.new-subscription-row-wrapper{display:none;}</style>'; // for page builder

	} else echo '<style>.current-subscription-row-wrapper{display:none;}</style>'; // for page builder

	if ( ! wpj_subscription_has_levels_defined() ) {
		wpj_display_message( array(
			'message_class'   => 'info',
			'is_hidden'       => false,
			'message_header'  => __( 'Subscription invalid!', 'wpjobster' ),
			'message_content' => __( 'Suscription levels not defined. Please contact the administrator of this site for help.', 'wpjobster' )
		) );

		echo '<style>.new-subscription-row-wrapper, .current-subscription-row-wrapper{display:none;}</style>'; // for page builder
	}

} else {
	wpj_display_message( array(
		'message_class'   => 'info',
		'is_hidden'       => false,
		'message_header'  => __( 'Subscriptions are disabled!', 'wpjobster' ),
		'message_content' => __( 'Subscriptions are not available at this time. Please contact the administrator of this site for help.', 'wpjobster' )
	) );

	echo '<style>.new-subscription-row-wrapper, .current-subscription-row-wrapper{display:none;}</style>'; // for page builder

}