<?php
/**
 * @var $order
 */

if ( ! current_user_can( 'manage_options' ) && get_current_user_id() != $order->user_id ) {

	wpj_display_message( array(
		'message_class'     => 'info',
		'is_hidden'         => false,
		'message_header'    => __( 'Access to this topup order is denied for you!', 'wpjobster' ),
		'message_content'   => __( 'You are not allowed to view this page because you are not involved in the transaction.', 'wpjobster' ),
		'content_paragraph' => false,
		'with_close_icon'   => false,
		'icon_class'        => false
	) );

	echo '<style>.bank-details-row-wrapper, .topup-order-details-row-wrapper, .topup-order-actions-row-wrapper{display:none;}</style>'; // for page builder

} else {
	if ( $order ) {
		if ( $order->payment_status == 'pending' && $order->payment_gateway_name == 'banktransfer' )
			echo '<style>.kt-button.button.topup-order-process-action-row-wrapper, .kt-button.button.topup-order-invoice-button{display:none;}</style>'; // for page builder

		if ( ! function_exists( 'is_plugin_active' ) ) {
			include_once ( ABSPATH . 'wp-admin/includes/plugin.php' );
		}

		if ( ! is_plugin_active( 'wpjobster-invoices/wpjobster-invoices.php' ) || $order->payment_status == 'pending' )
			echo '<style>.kt-button.button.topup-order-invoice-button{display:none;}</style>'; // for page builder

		if ( $order->payment_status != 'pending' )
			echo '<style>.kt-button.button.topup-order-cancel-button, .kt-button.button.topup-order-process-action-row-wrapper{display:none;}</style>'; // for page builder
	}
}