<?php
/**
 * @var $uid
 * @var $box_status
 * @var $status_class
 * @var $user_nicename
 * @var $attach_class
 */
?>

<div class="message-box-container" rel="<?php echo $uid; ?>" style="display: none;">

	<div class="message-box-wrapper has-focus<?php if ( $box_status == 'minimized' ) { echo ' minimized'; } ?>" style="<?php echo is_rtl() ? 'left' : 'right'; ?>: 220px;<?php if ( $box_status == 'minimized' ) { echo ' width: 200px;'; } ?>" data-uid="<?php echo $uid; ?>">

		<div class="cf message-box-head">

			<div class="message-box-head-content">

				<div aria-hidden="true" class="message-box-logo-area">

					<a class="left" tabindex="-1" href="<?php echo wpj_get_user_profile_link( $uid ); ?>">

						<div class="message-box-logo-container">

							<?php wpj_display_user_photo( array( 'uid' => $uid, 'width' => 28, 'height' => 28, 'with_level_image' => false, 'with_link' => false ) ); ?>

						</div>

					</a>

					<div class="message-box-user-status <?php echo $status_class; ?>"></div>

				</div>

				<div class="message-box-head-user">

					<div class="message-box-user-info">

						<div class="message-box-user-info-title-container">

							<a href="<?php echo wpj_get_user_profile_link( $uid ); ?>">

								<span class="message-box-user-info-title"><?php echo wpj_get_user_display_type( $uid ); ?></span>

							</a>

						</div>

						<div class="message-box-user-info-status">

							<div><?php echo wpj_get_last_visit( $uid ); ?></div>

						</div>

					</div>

					<div class="message-box-head-buttons">

						<!-- Minimize -->
						<div data-inverted="" data-tooltip="<?php _e( 'Minimize chat', 'wpjobster' ); ?>" data-position="top right"><i class="minus icon"></i></a></div>

						<!-- Open in Messages BTN -->
						<div data-inverted="" data-tooltip="<?php _e( 'Open in messages', 'wpjobster' ); ?>" data-position="top right" class="message-box-maximize"><a href="<?php echo wpj_get_pm_link( $user_nicename ); ?>"><i class="icon expand"></i></a></div>

						<!-- Close BTN -->
						<div data-inverted="" data-tooltip="<?php _e( 'Close chat', 'wpjobster' ); ?>" data-position="top right" class="message-box-close"><span>&#10005;</span></div>

					</div>

				</div>

			</div>

		</div>

		<div class="message-box-body"<?php if ( $box_status == 'minimized' ) { echo ' style="display:none"'; } ?>>

			<div class="message-box-content thread-viewport js-messages-list">

				<div class="thread-content">

					<?php wpj_display_messages_list( array(
						'user1'            => get_current_user_id(),
						'user2'            => $uid,
						'message_type'     => 'all',
						'display_location' => 'chat'
					) ); ?>

				</div>

			</div>

		</div>

		<div class="message-box-footer" data-no-translation>

			<div class="message-box-footer-images-uploader">

				<?php if ( wpj_get_option( 'wpjobster_message_image_attachments_enable' ) != 'no' )
					wpj_display_image_upload_form( $uid, 'message', 'messages-image-uploader', 'chat_images_' . $uid ); ?>

			</div>

			<div class="message-box-footer-options" style="display: none;">

				<?php if ( wpj_get_option( 'wpjobster_message_image_attachments_enable' ) != 'no' ) { ?>

					<div class="option-wrapper message-box-image-attachments" data-content="<?php _e( 'Attach a photo', 'wpjobster' ); ?>">

						<div class="message-box-image-attachments-content <?php echo $attach_class; ?> js-chat-img-attach-btn">

							<i class="file image outline icon message-box-image-attachment-icon"></i>

						</div>

					</div>

				<?php }

				if ( wpj_get_option( 'wpjobster_message_attachments_enable' ) != 'no' ) { ?>

					<div class="option-wrapper message-box-attachments" data-content="<?php _e( 'Attach a file', 'wpjobster' ); ?>">

						<?php wpj_display_file_upload_form( $secure = 1, "file_upload_chat_attachments_" . $uid, "hidden_files_chat_attachments_" . $uid, "chat_messages_" . $uid, true ); ?>

					</div>

				<?php } ?>

				<div class="option-wrapper" data-content="<?php _e( 'Choose a response', 'wpjobster' ); ?>">

					<?php wpj_display_quick_response( $uid, 'chat' ); ?>

				</div>

				<?php if ( wpj_get_option( 'wpjobster_enable_custom_offers' ) != 'no' ) {

					if ( apply_filters( 'hide_for_buyers', true, $uid ) ) { ?>

						<div class="option-wrapper" data-content="<?php _e( 'Request a custom offer', 'wpjobster' ); ?>">

							<?php wpj_display_custom_offer_button( array(
								'unique_id'       => 'chat_request_' . $uid,
								'id'              => $uid,
								'title'           => __( 'Request Custom Offer', 'wpjobster' ),
								'offer_type'      => 'request',
								'current_user_id' => get_current_user_id(),
								'post_author_id'  => $uid,
								'page'            => 'chat',
								'label_type'      => 'icon',
								'label_icon'      => 'pencil alternate'
							) ); ?>

						</div>

					<?php }

					if ( apply_filters( 'hide_for_buyers', true, get_current_user_id() ) ) { ?>

						<div class="option-wrapper" data-content="<?php _e( 'Send a custom offer', 'wpjobster' ); ?>">

							<?php wpj_display_custom_offer_button( array(
								'unique_id'       => 'chat_send_' . $uid,
								'id'              => $uid,
								'title'           => __( 'Send Custom Offer', 'wpjobster' ),
								'offer_type'      => 'send',
								'current_user_id' => get_current_user_id(),
								'post_author_id'  => $uid,
								'page'            => 'chat',
								'label_type'      => 'icon',
								'label_icon'      => 'clipboard check'
							) ); ?>

						</div>

					<?php }

				}

				do_action( 'wpj_after_messagebox_footer_options', $uid, get_current_user_id() ); ?>

			</div>

			<div class="pr vertical-align-middle">

				<div class="message-box-footer-buttons">

					<i class="plus circle icon message-options-icon js-message-options-btn"></i>

				</div>

				<div tabindex="-1" class="message-box-footer-textarea">

					<div class="message-box-placeholder-container">

						<div class="message-box-placeholder-wrapper">

							<div class="message-box-placeholder-content"><?php _e( 'Write a message...', 'wpjobster' ); ?></div>

						</div>

					</div>

					<div class="message-box-input-wrapper">

						<div aria-expanded="false" id="message_box_input_content" class="message-box-input-content message-field <?php echo $uid; ?>" contenteditable="true" role="combobox" spellcheck="true"><span><br data-text="true"></span></div>

					</div>

				</div>

				<div class="message-box-footer-send-button flip-on-rtl js-message-box-footer-send-button">
					<i class="icons">
						<i class="play icon"></i>
						<i class="white minus icon"></i>
					</i>
				</div>

			</div>

		</div>

	</div>

</div>