<?php
/**
 * @var $users
 */

if ( $users ) { ?>

	<div class="chat-sidebar-minimal-container js-chat-sidebar">

		<div class="chat-sidebar-minimal-wrapper">

			<div class="chat-sidebar-notifications">

				<?php _e( 'Not found!', 'wpjobster' ) ?>

			</div>

			<div class="chat-sidebar-users-list">

				<?php if ( $users ) {

					foreach ( $users as $user ) { ?>

						<div class="chat-sidebar-user-box" data-box-id="<?php echo $user['ID']; ?>" <?php if ( wpj_is_conversation_archived( $user['ID'] ) ) { echo 'style="display: none";'; } ?>>

							<div data-inverted="" data-tooltip="<?php echo $user['user_login']; ?>" data-position="left center">

								<span data-nicename="<?php echo $user['user_nicename']; ?>" class="user-name"><?php echo $user['user_login']; ?></span>

								<?php wpj_display_user_photo( array( 'uid' => $user['ID'], 'width' => 30, 'height' => 30, 'with_level_image' => false, 'with_link' => false, 'img_class' => 'user-avatar' ) );

								wpj_display_user_status_icon( $user['ID'], 'yes_with_icon', false ); ?>

							</div>

						</div>

					<?php }

				} ?>

			</div>

			<div class="chat-sidebar-user-search">

				<div class="ui mini inverted input chat-sidebar-user-search-input">

					<input class="chat-sidebar-inp-user-search" type="text" onkeyup="wpj_chat_search_user_sidebar( this )" placeholder="<?php _e( 'Search...', 'wpjobster' ); ?>">

				</div>

				<i class="search icon chat-sidebar-user-search-icon"></i>

			</div>

		</div>

	</div>

<?php }