<?php
/**
 * @var $icon
 * @var $user_on_cnt
 * @var $users
 */
?>

<div class="chat-sidebar-container js-chat-sidebar">

	<div class="chat-sidebar-anchor">

		<div class="chat-sidebar-anchor-icon">

			<i class="<?php echo $icon; ?> icon"></i>

		</div>

		<div class="chat-sidebar-anchor-text">

			<?php echo sprintf( __( 'Chat (%d)', 'wpjobster' ), $user_on_cnt ); ?>

		</div>

	</div>

	<div class="chat-sidebar-wrapper">

		<div class="chat-sidebar-content">

			<div class="chat-sidebar-notifications" <?php if ( ! $users ) { echo 'style="display: block;"'; } ?>>

				<?php _e( 'No user found', 'wpjobster' ) ?>

			</div>

			<div class="chat-sidebar-users-list">

				<?php if ( $users ) {

					foreach ( $users as $user ) { ?>

						<div class="chat-sidebar-user-box" data-box-id="<?php echo $user['ID']; ?>" <?php if ( wpj_is_conversation_archived( $user['ID'] ) ) { echo 'style="display: none";'; } ?>>

							<!-- Avatar-->
							<?php wpj_display_user_photo( array( 'uid' => $user['ID'], 'width' => 30, 'height' => 30, 'with_level_image' => false, 'with_link' => false, 'img_class' => 'user-avatar' ) ); ?>

							<!-- Username -->
							<span data-nicename="<?php echo $user['user_nicename']; ?>" class="user-name"><?php echo $user['user_login']; ?></span>

							<!-- Unread messages -->
							<?php if ( $user['unread_messages'] > 0 ) { ?>

								<span class="msg-unread-count"><?php echo $user['unread_messages']; ?></span>

							<?php } ?>

							<!-- Archive conversation -->
							<a class="archive-conversation"><i class="close icon"></i></a>

							<!-- Status -->
							<div class="user-status-wrapper">

								<?php if ( $user['time_elapsed'] && $user['time_elapsed'] <= 359 /* 359 seconds */ ) { // online bullet ?>

									<div class="status-icon-wrapper online-icon-wrapper">

										<span class="online-bullet"> &bull; </span>

									</div>

								<?php } elseif ( $user['time_elapsed'] && $user['time_elapsed'] <= 172800 /* 172800 seconds */ ) { // offline text

									echo wpj_seconds_to_words( $user['time_elapsed'], true );

								} else { // offline bullet ?>

									<div class="status-icon-wrapper offline-icon-wrapper">

										<span class="offline-bullet"> &bull; </span>

									</div>

								<?php } ?>

							</div>

						</div>

					<?php }

				} ?>

			</div>

			<!-- User search -->
			<div class="chat-sidebar-user-search">

				<div class="ui left icon input w100">

					<input class="chat-sidebar-inp-user-search" type="text" onkeyup="wpj_chat_search_user_sidebar( this )" placeholder="<?php _e( 'Search...', 'wpjobster' ); ?>">

					<i class="search icon"></i>

				</div>

			</div>

		</div>

	</div>

</div>