<?php
/**
 * @var $notifications_array
 * @var $user_id
 */
?>

<div class="wpj-bordered-container email-sms-settings-column">

	<h4><?php _e( 'Email', 'wpjobster' ); ?></h4>

	<ul class="notifications mail_notification reset">

		<li id="all-mail">

			<div class="ui checkbox">

				<input id="all-email-notify" type="checkbox" value="mark_all_email_notify" />

				<label class="check-all"><?php _e( 'Check all', 'wpjobster' ); ?></label>

			</div>

		</li>

		<?php if ( $notifications_array ) {

			foreach ( $notifications_array as $email_category ) {

				if ( isset( $email_category["items"] ) && $email_category["items"] ) {

					foreach ( $email_category["items"] as $reason => $pair ) {

						if ( wpj_get_option( 'uz_email_' . $reason . '_enable' ) != 'no' ) { ?>

							<li>

								<div class="ui checkbox">

									<input type="checkbox" class="email_notifications" name="email_notifications[]" <?php echo ( get_user_meta( $user_id, 'uz_email_' . $reason . '_enable', true ) != "no" ? " checked " : '' ); ?> value="uz_email_<?php echo $reason; ?>_enable" />

									<label><?php echo $pair["title"]; ?></label>

								</div>

							</li>

						<?php }

					}

				}

			}

		} ?>

	</ul>

</div>